/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.gui.dialogs.HistoryDialog;
import org.openstreetmap.josm.gui.history.HistoryBrowser;
import org.openstreetmap.josm.tools.I18n;

public class HistoryBrowserDialog
extends JDialog {
    private HistoryBrowser browser;

    protected void renderTitle(History history) {
        String string = I18n.tr("History for {0} {1}", history.getEarliest().getType().getLocalizedDisplayNameSingular(), Long.toString(history.getId()));
        this.setTitle(string);
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.browser = new HistoryBrowser();
        this.add((Component)this.browser, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(new CloseAction());
        jButton.setName("btn.close");
        jPanel.add(jButton);
        this.add((Component)jPanel, "South");
        this.setSize(800, 500);
    }

    public HistoryBrowserDialog(History history) {
        super(JOptionPane.getFrameForComponent(Main.parent), false);
        this.setAlwaysOnTop(true);
        this.build();
        this.setHistory(history);
        this.renderTitle(history);
    }

    protected void setHistory(History history) {
        this.browser.populate(history);
    }

    protected void register() {
        HistoryDialog.registerHistoryBrowserDialog(this.browser.getHistory().getId(), this);
    }

    protected void unregister() {
        HistoryDialog.unregisterHistoryBrowserDialog(this.browser.getHistory().getId());
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.register();
            this.toFront();
        } else {
            this.unregister();
        }
        super.setVisible(bl);
    }

    public HistoryBrowser getHistoryBrowser() {
        return this.browser;
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            this.putValue("Name", I18n.tr("Close"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HistoryBrowserDialog.this.setVisible(false);
        }
    }
}

