/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.ac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletionCache {
    private static HashMap<OsmDataLayer, AutoCompletionCache> caches = new HashMap();
    private HashMap<String, ArrayList<String>> cache = new HashMap();
    private OsmDataLayer layer;

    public static AutoCompletionCache getCacheForLayer(OsmDataLayer osmDataLayer) {
        AutoCompletionCache autoCompletionCache = caches.get(osmDataLayer);
        if (autoCompletionCache == null) {
            autoCompletionCache = new AutoCompletionCache(osmDataLayer);
            caches.put(osmDataLayer, autoCompletionCache);
        }
        return autoCompletionCache;
    }

    public AutoCompletionCache(OsmDataLayer osmDataLayer) {
        this.layer = osmDataLayer;
    }

    public AutoCompletionCache() {
        this(null);
    }

    protected void cacheKey(String string) {
        if (this.cache.containsKey(string)) {
            return;
        }
        this.cache.put(string, new ArrayList());
    }

    protected void cacheValue(String string, String string2) {
        this.cacheKey(string);
        ArrayList<String> arrayList = this.cache.get(string);
        if (!arrayList.contains(string2)) {
            arrayList.add(string2);
        }
    }

    protected void cachePrimitive(OsmPrimitive osmPrimitive) {
        for (String string : osmPrimitive.keySet()) {
            String string2 = osmPrimitive.get(string);
            this.cacheValue(string, string2);
        }
    }

    public void initFromJOSMDataset() {
        this.cache = new HashMap();
        if (this.layer == null) {
            return;
        }
        Collection<OsmPrimitive> collection = this.layer.data.allNonDeletedPrimitives();
        for (OsmPrimitive osmPrimitive : collection) {
            this.cachePrimitive(osmPrimitive);
        }
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.cache.keySet());
    }

    public List<String> getValues(String string) {
        if (!this.cache.containsKey(string)) {
            return new ArrayList<String>();
        }
        return this.cache.get(string);
    }

    static {
        Layer.listeners.add(new Layer.LayerChangeListener(){

            public void activeLayerChange(Layer layer, Layer layer2) {
            }

            public void layerAdded(Layer layer) {
            }

            public void layerRemoved(Layer layer) {
                if (layer instanceof OsmDataLayer) {
                    caches.remove(layer);
                }
            }
        });
    }
}

