/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.dialogs.relation.TagEditorModel;
import org.openstreetmap.josm.gui.dialogs.relation.TagModel;
import org.openstreetmap.josm.tools.I18n;

public class TagCellRenderer
extends JLabel
implements TableCellRenderer {
    private static Logger logger = Logger.getLogger(TagCellRenderer.class.getName());
    public static final Color BG_COLOR_SELECTED = new Color(143, 170, 255);
    public static final Color BG_COLOR_HIGHLIGHTED = new Color(255, 255, 204);
    public static final Border BORDER_EMPHASIZED = BorderFactory.createLineBorder(new Color(253, 75, 45));
    private ImageIcon deleteIcon = null;
    private Font fontStandard = this.getFont();
    private Font fontItalic = this.fontStandard.deriveFont(2);

    public TagCellRenderer() {
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    protected void renderTagName(TagModel tagModel) {
        this.setText(tagModel.getName());
    }

    protected void renderTagValue(TagModel tagModel) {
        if (tagModel.getValueCount() == 0) {
            this.setText("");
        } else if (tagModel.getValueCount() == 1) {
            this.setText(tagModel.getValues().get(0));
        } else if (tagModel.getValueCount() > 1) {
            this.setText(I18n.tr("<multiple>"));
            this.setFont(this.fontItalic);
        }
    }

    protected void resetRenderer() {
        this.setText("");
        this.setIcon(null);
        this.setFont(this.fontStandard);
    }

    protected TagEditorModel getModel(JTable jTable) {
        return (TagEditorModel)jTable.getModel();
    }

    protected void renderBackgroundColor(TagModel tagModel, TagEditorModel tagEditorModel) {
        this.setBackground(Color.WHITE);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.resetRenderer();
        if (bl) {
            this.setBackground(BG_COLOR_SELECTED);
        } else {
            this.renderBackgroundColor(this.getModel(jTable).get(n), this.getModel(jTable));
        }
        switch (n2) {
            case 0: {
                this.renderTagName((TagModel)object);
                break;
            }
            case 1: {
                this.renderTagValue((TagModel)object);
                break;
            }
            default: {
                throw new RuntimeException("unexpected index in switch statement");
            }
        }
        if (bl2 && bl && jTable.getSelectedColumnCount() == 1 && jTable.getSelectedRowCount() == 1) {
            boolean bl3 = jTable.editCellAt(n, n2);
            if (jTable.getEditorComponent() != null) {
                jTable.getEditorComponent().requestFocusInWindow();
            }
        }
        return this;
    }
}

