/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.gui.dialogs.relation.TagEditorModel;
import org.openstreetmap.josm.gui.dialogs.relation.TagFieldEditor;
import org.openstreetmap.josm.gui.dialogs.relation.TagModel;
import org.openstreetmap.josm.gui.dialogs.relation.ac.AutoCompletionCache;
import org.openstreetmap.josm.gui.dialogs.relation.ac.AutoCompletionItemPritority;
import org.openstreetmap.josm.gui.dialogs.relation.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.dialogs.relation.ac.AutoCompletionListItem;

public class TagCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static Logger logger = Logger.getLogger(TagCellEditor.class.getName());
    private TagFieldEditor editor = new TagFieldEditor();
    private TagModel currentTag = null;
    private TagEditorModel tagEditorModel = null;
    private int currentColumn = 0;
    private AutoCompletionCache acCache = new AutoCompletionCache();
    private AutoCompletionList autoCompletionList = null;

    protected void initAutoCompletionListForKeys(TagEditorModel tagEditorModel, TagModel tagModel) {
        if (this.autoCompletionList == null) {
            logger.warning("autoCompletionList is null. Make sure an instance of AutoCompletionList is injected into TableCellEditor.");
            return;
        }
        this.autoCompletionList.clear();
        for (String string : this.acCache.getKeys()) {
            this.autoCompletionList.add(new AutoCompletionListItem(string, AutoCompletionItemPritority.IS_IN_DATASET));
        }
        for (String string : tagEditorModel.getKeys()) {
            if (string.equals(tagModel.getName())) continue;
            this.autoCompletionList.remove(string);
        }
        this.autoCompletionList.fireTableDataChanged();
    }

    protected void initAutoCompletionListForValues(String string) {
        if (this.autoCompletionList == null) {
            logger.warning("autoCompletionList is null. Make sure an instance of AutoCompletionList is injected into TableCellEditor.");
            return;
        }
        this.autoCompletionList.clear();
        for (String string2 : this.acCache.getValues(string)) {
            this.autoCompletionList.add(new AutoCompletionListItem(string2, AutoCompletionItemPritority.IS_IN_DATASET));
        }
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.currentTag = (TagModel)object;
        if (n2 == 0) {
            this.editor.setText(this.currentTag.getName());
            this.currentColumn = 0;
            TagEditorModel tagEditorModel = (TagEditorModel)jTable.getModel();
            this.initAutoCompletionListForKeys(tagEditorModel, this.currentTag);
            return this.editor;
        }
        if (n2 == 1) {
            if (this.currentTag.getValueCount() == 0) {
                this.editor.setText("");
            } else if (this.currentTag.getValueCount() == 1) {
                this.editor.setText(this.currentTag.getValues().get(0));
            } else {
                this.editor.setText("");
            }
            this.currentColumn = 1;
            this.initAutoCompletionListForValues(this.currentTag.getName());
            return this.editor;
        }
        logger.warning("column this table cell editor is requested for is out of range. column=" + n2);
        return null;
    }

    public Object getCellEditorValue() {
        return this.editor.getText();
    }

    public void cancelCellEditing() {
        super.cancelCellEditing();
    }

    public boolean stopCellEditing() {
        if (this.tagEditorModel == null) {
            logger.warning("no tag editor model set. Can't update edited values. Please set tag editor model first");
            return super.stopCellEditing();
        }
        if (this.currentColumn == 0) {
            this.tagEditorModel.updateTagName(this.currentTag, this.editor.getText());
        } else if (this.currentColumn == 1) {
            if (this.currentTag.getValueCount() > 1 && !this.editor.getText().equals("")) {
                this.tagEditorModel.updateTagValue(this.currentTag, this.editor.getText());
            } else if (this.currentTag.getValueCount() <= 1) {
                this.tagEditorModel.updateTagValue(this.currentTag, this.editor.getText());
            }
        }
        return super.stopCellEditing();
    }

    public AutoCompletionList getAutoCompletionList() {
        return this.autoCompletionList;
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        this.autoCompletionList = autoCompletionList;
        this.editor.setAutoCompletionList(autoCompletionList);
    }

    public void setAutoCompletionCache(AutoCompletionCache autoCompletionCache) {
        this.acCache = autoCompletionCache;
    }

    public void autoCompletionItemSelected(String string) {
        this.editor.setText(string);
        this.editor.selectAll();
        this.editor.requestFocus();
    }

    public TagFieldEditor getEditor() {
        return this.editor;
    }

    public void setTagEditorModel(TagEditorModel tagEditorModel) {
        this.tagEditorModel = tagEditorModel;
    }
}

