/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationEditor
extends ExtendedDialog {
    private static RelationDialogManager relationDialogManager;
    public static ArrayList<Class<RelationEditor>> editors;
    private Relation relation;
    private Relation clone;
    private OsmDataLayer layer;

    public static RelationDialogManager getRelationDialogManager() {
        if (relationDialogManager == null) {
            relationDialogManager = new RelationDialogManager();
            Layer.listeners.add(relationDialogManager);
        }
        return relationDialogManager;
    }

    public static RelationEditor getEditor(OsmDataLayer osmDataLayer, Relation relation, Collection<RelationMember> collection) {
        for (Class<RelationEditor> clazz : editors) {
            try {
                Method method = clazz.getMethod("canEdit", Relation.class);
                Boolean bl = (Boolean)method.invoke(null, relation);
                if (!bl.booleanValue()) continue;
                Constructor<RelationEditor> constructor = clazz.getConstructor(Relation.class, Collection.class);
                RelationEditor relationEditor = constructor.newInstance(osmDataLayer, relation, collection);
                return relationEditor;
            }
            catch (Exception exception) {
            }
        }
        if (RelationEditor.getRelationDialogManager().isOpenInEditor(osmDataLayer, relation)) {
            return RelationEditor.getRelationDialogManager().getEditorForRelation(osmDataLayer, relation);
        }
        GenericRelationEditor genericRelationEditor = new GenericRelationEditor(osmDataLayer, relation, collection);
        RelationEditor.getRelationDialogManager().register(osmDataLayer, relation, genericRelationEditor);
        return genericRelationEditor;
    }

    protected RelationEditor(OsmDataLayer osmDataLayer, Relation relation, Collection<RelationMember> collection) {
        super(Main.parent, relation == null ? I18n.tr("Create new relation in layer ''{0}''", osmDataLayer.getName()) : (relation.id == 0L ? I18n.tr("Edit new relation in layer ''{0}''", osmDataLayer.getName()) : I18n.tr("Edit relation #{0} in layer ''{1}''", relation.id, osmDataLayer.getName())), new String[]{I18n.tr("Apply Changes"), I18n.tr("Cancel")}, false);
        this.relation = relation;
        this.layer = osmDataLayer;
        this.clone = relation == null ? new Relation() : new Relation(relation);
    }

    protected Relation getRelation() {
        return this.relation;
    }

    protected Relation getClone() {
        return this.clone;
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    static {
        editors = new ArrayList();
    }
}

