/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialog;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmServerHistoryReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class HistoryDialog
extends ToggleDialog {
    private static HashMap<Long, HistoryBrowserDialog> historyBrowserDialogs;
    protected HistoryItemDataModel model;
    protected JTable historyTable;
    protected ShowHistoryAction showHistoryAction;
    protected ReloadAction reloadAction;

    public static void registerHistoryBrowserDialog(long l, HistoryBrowserDialog historyBrowserDialog) {
        if (historyBrowserDialogs == null) {
            historyBrowserDialogs = new HashMap();
        }
        historyBrowserDialogs.put(l, historyBrowserDialog);
    }

    public static void unregisterHistoryBrowserDialog(long l) {
        if (historyBrowserDialogs == null) {
            return;
        }
        historyBrowserDialogs.remove(l);
    }

    public static HistoryBrowserDialog getHistoryBrowserDialog(long l) {
        if (historyBrowserDialogs == null) {
            return null;
        }
        return historyBrowserDialogs.get(l);
    }

    protected JPanel buildButtonRow() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        this.reloadAction = new ReloadAction();
        SideButton sideButton = new SideButton(this.reloadAction);
        sideButton.setName("btn.reload");
        jPanel.add(sideButton);
        this.showHistoryAction = new ShowHistoryAction();
        sideButton = new SideButton(this.showHistoryAction);
        sideButton.setName("btn.showhistory");
        jPanel.add(sideButton);
        return jPanel;
    }

    protected void build() {
        this.model = new HistoryItemDataModel();
        this.historyTable = new JTable(this.model, new HistoryTableColumnModel());
        this.historyTable.setSelectionMode(0);
        this.historyTable.setName("table.historyitems");
        final TableCellRenderer tableCellRenderer = this.historyTable.getTableHeader().getDefaultRenderer();
        this.historyTable.getTableHeader().setDefaultRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (!object.equals("")) {
                    return jComponent;
                }
                JLabel jLabel = new JLabel(ImageProvider.get("misc", "showhide"));
                jLabel.setForeground(jComponent.getForeground());
                jLabel.setBackground(jComponent.getBackground());
                jLabel.setFont(jComponent.getFont());
                jLabel.setBorder(jComponent.getBorder());
                jLabel.setOpaque(true);
                return jLabel;
            }
        });
        this.historyTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = HistoryDialog.this.historyTable.rowAtPoint(mouseEvent.getPoint());
                    History history = HistoryDialog.this.model.get(n);
                    HistoryDialog.this.showHistory(history);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.historyTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.historyTable.setTableHeader(null);
        jScrollPane.setColumnHeaderView(null);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.buildButtonRow(), "South");
        this.historyTable.getSelectionModel().addListSelectionListener(this.showHistoryAction);
        DataSet.selListeners.add(this.reloadAction);
    }

    public HistoryDialog() {
        super(I18n.tr("History"), "history", I18n.tr("Display the history of all selected items."), Shortcut.registerShortcut("subwindow:history", I18n.tr("Toggle: {0}", I18n.tr("History")), 72, 4, 1), 150);
        this.build();
        DataSet.selListeners.add(this.model);
    }

    protected void refresh() {
        HistoryLoadTask historyLoadTask = new HistoryLoadTask();
        Main.worker.execute(historyLoadTask);
    }

    protected void showHistory(History history) throws IllegalArgumentException {
        if (history == null) {
            throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' must not be null", "h"));
        }
        HistoryBrowserDialog historyBrowserDialog = HistoryDialog.getHistoryBrowserDialog(history.getId());
        if (historyBrowserDialog == null) {
            historyBrowserDialog = new HistoryBrowserDialog(history);
        }
        historyBrowserDialog.setVisible(true);
    }

    protected void postRefresh(HistoryLoadTask historyLoadTask) {
        this.model.refresh();
        if (historyLoadTask.isCancelled()) {
            return;
        }
        if (historyLoadTask.getLastException() != null) {
            historyLoadTask.getLastException().printStackTrace();
            String string = null;
            if (historyLoadTask.getLastException() instanceof OsmApiException && (string = ((OsmApiException)historyLoadTask.getLastException()).getErrorBody()) == null) {
                string = ((OsmApiException)historyLoadTask.getLastException()).getErrorHeader();
            }
            if (string == null) {
                string = historyLoadTask.getLastException().getMessage();
            }
            if (string == null) {
                string = historyLoadTask.getLastException().toString();
            }
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to load history from the server. Details:<br>{0}</html>", string.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;")), I18n.tr("Error"), 0);
        }
    }

    class ShowHistoryAction
    extends AbstractAction
    implements ListSelectionListener {
        public ShowHistoryAction() {
            this.putValue("Name", I18n.tr("Show"));
            this.putValue("ShortDescription", I18n.tr("Display the history of the selected primitive"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = HistoryDialog.this.historyTable.getSelectionModel().getMinSelectionIndex();
            if (n < 0) {
                return;
            }
            History history = HistoryDialog.this.model.get(n);
            HistoryDialog.this.showHistory(history);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(HistoryDialog.this.historyTable.getSelectionModel().getMinSelectionIndex() >= 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReloadAction
    extends AbstractAction
    implements SelectionChangedListener {
        public ReloadAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
            this.putValue("ShortDescription", I18n.tr("Reload all currently selected objects and refresh the list."));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HistoryDialog.this.refresh();
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            this.setEnabled(Main.ds.getSelected().size() > 0);
        }
    }

    class HistoryLoadTask
    extends PleaseWaitRunnable {
        private boolean cancelled;
        private Exception lastException;

        public HistoryLoadTask() {
            super(I18n.tr("Load history"), true);
            this.cancelled = false;
            this.lastException = null;
        }

        protected void cancel() {
            OsmApi.getOsmApi().cancel();
            this.cancelled = true;
        }

        protected void finish() {
            HistoryDialog.this.postRefresh(this);
        }

        protected void notifyStartLoadingHistory(final OsmPrimitive osmPrimitive) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Main.pleaseWaitDlg.setTitle(I18n.tr("Loading history for {0} with id {1}", OsmPrimitiveType.from(osmPrimitive).getLocalizedDisplayNameSingular(), Long.toString(osmPrimitive.id)));
                }
            });
        }

        protected void setInterminateEnabled(final boolean bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Main.pleaseWaitDlg.setIndeterminate(bl);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            block12: {
                Collection<OsmPrimitive> collection = Main.ds.getSelected();
                Iterator<OsmPrimitive> iterator = collection.iterator();
                this.setInterminateEnabled(true);
                block8: while (true) {
                    try {
                        while (iterator.hasNext()) {
                            OsmPrimitive osmPrimitive = iterator.next();
                            if (this.cancelled) {
                                break block12;
                            }
                            if (osmPrimitive.id == 0L) continue;
                            this.notifyStartLoadingHistory(osmPrimitive);
                            OsmServerHistoryReader osmServerHistoryReader = null;
                            HistoryDataSet historyDataSet = null;
                            try {
                                osmServerHistoryReader = new OsmServerHistoryReader(OsmPrimitiveType.from(osmPrimitive), osmPrimitive.id);
                                historyDataSet = osmServerHistoryReader.parseHistory();
                            }
                            catch (OsmTransferException osmTransferException) {
                                if (this.cancelled) {
                                    this.setInterminateEnabled(false);
                                    return;
                                }
                                throw osmTransferException;
                            }
                            HistoryDataSet.getInstance().mergeInto(historyDataSet);
                            continue block8;
                        }
                        break block12;
                    }
                    catch (OsmTransferException osmTransferException) {
                        this.lastException = osmTransferException;
                        return;
                    }
                }
                finally {
                    this.setInterminateEnabled(false);
                }
            }
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public Exception getLastException() {
            return this.lastException;
        }
    }

    class HistoryTableColumnModel
    extends DefaultTableColumnModel {
        protected void createColumns() {
            TableColumn tableColumn = null;
            HistoryTableCellRenderer historyTableCellRenderer = new HistoryTableCellRenderer();
            tableColumn = new TableColumn(0);
            tableColumn.setHeaderValue(I18n.tr("History item"));
            tableColumn.setCellRenderer(historyTableCellRenderer);
            this.addColumn(tableColumn);
        }

        public HistoryTableColumnModel() {
            this.createColumns();
        }
    }

    class HistoryTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
        private HashMap<OsmPrimitiveType, ImageIcon> icons;

        public HistoryTableCellRenderer() {
            this.setOpaque(true);
            this.icons = new HashMap();
            this.icons.put(OsmPrimitiveType.NODE, ImageProvider.get("data", "node"));
            this.icons.put(OsmPrimitiveType.WAY, ImageProvider.get("data", "way"));
            this.icons.put(OsmPrimitiveType.RELATION, ImageProvider.get("data", "relation"));
        }

        protected void renderIcon(History history) {
            this.setIcon(this.icons.get((Object)history.getEarliest().getType()));
        }

        protected void renderText(History history) {
            this.setText(history.getEarliest().getType().getLocalizedDisplayNameSingular() + " " + history.getId());
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            History history = (History)object;
            this.renderIcon(history);
            this.renderText(history);
            if (bl) {
                this.setBackground(this.BGCOLOR_SELECTED);
            } else {
                this.setBackground(Color.WHITE);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HistoryItemDataModel
    extends DefaultTableModel
    implements SelectionChangedListener {
        private ArrayList<History> data = new ArrayList();

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void refresh() {
            this.data.clear();
            for (OsmPrimitive osmPrimitive : Main.ds.getSelected()) {
                History history;
                if (osmPrimitive.id == 0L || (history = HistoryDataSet.getInstance().getHistory(osmPrimitive.id)) == null) continue;
                this.data.add(history);
            }
            this.fireTableDataChanged();
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            this.refresh();
        }

        public History get(int n) throws IndexOutOfBoundsException {
            if (n < 0 || n >= this.data.size()) {
                throw new IndexOutOfBoundsException(I18n.tr("index out of bounds Got {0}", n));
            }
            return this.data.get(n);
        }
    }
}

