/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.gui.conflict.ConflictResolver;
import org.openstreetmap.josm.gui.conflict.properties.OperationCancelledException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ConflictResolutionDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(ConflictResolutionDialog.class.getName());
    public static final Dimension DEFAULT_SIZE = new Dimension(600, 400);
    private ConflictResolver resolver;

    protected void restorePositionAndDimension() {
        Point point = new Point();
        Dimension dimension = new Dimension();
        try {
            point.x = Integer.parseInt(Main.pref.get("conflictresolutiondialog.x", "0"));
            point.x = Math.max(0, point.x);
        }
        catch (Exception exception) {
            logger.warning("unexpected value for preference conflictresolutiondialog.x, assuming 0");
            point.x = 0;
        }
        try {
            point.y = Integer.parseInt(Main.pref.get("conflictresolutiondialog.y", "0"));
            point.y = Math.max(0, point.y);
        }
        catch (Exception exception) {
            logger.warning("unexpected value for preference conflictresolutiondialog.x, assuming 0");
            point.y = 0;
        }
        try {
            dimension.width = Integer.parseInt(Main.pref.get("conflictresolutiondialog.width", Integer.toString(ConflictResolutionDialog.DEFAULT_SIZE.width)));
            dimension.width = Math.max(0, dimension.width);
        }
        catch (Exception exception) {
            logger.warning("unexpected value for preference conflictresolutiondialog.width, assuming " + ConflictResolutionDialog.DEFAULT_SIZE.width);
            point.y = 0;
        }
        try {
            dimension.height = Integer.parseInt(Main.pref.get("conflictresolutiondialog.height", Integer.toString(ConflictResolutionDialog.DEFAULT_SIZE.height)));
            dimension.height = Math.max(0, dimension.height);
        }
        catch (Exception exception) {
            logger.warning("unexpected value for preference conflictresolutiondialog.height, assuming " + ConflictResolutionDialog.DEFAULT_SIZE.height);
            point.y = 0;
        }
        this.setLocation(point);
        this.setSize(dimension);
    }

    protected void rememberPositionAndDimension() {
        Point point = this.getLocation();
        Main.pref.put("conflictresolutiondialog.x", Integer.toString(point.x));
        Main.pref.put("conflictresolutiondialog.y", Integer.toString(point.y));
        Dimension dimension = this.getSize();
        Main.pref.put("conflictresolutiondialog.width", Integer.toString(dimension.width));
        Main.pref.put("conflictresolutiondialog.height", Integer.toString(dimension.height));
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.restorePositionAndDimension();
        } else {
            this.rememberPositionAndDimension();
        }
        super.setVisible(bl);
    }

    protected JPanel buildButtonRow() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        JButton jButton = new JButton(new ApplyResolutionAction());
        jButton.setName("button.apply");
        jPanel.add(jButton);
        jButton = new JButton(new CancelAction());
        jButton.setName("button.cancel");
        jPanel.add(jButton);
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        return jPanel;
    }

    protected void build() {
        this.setTitle(I18n.tr("Resolve conflicts"));
        this.getContentPane().setLayout(new BorderLayout());
        this.resolver = new ConflictResolver();
        this.resolver.setName("panel.conflictresolver");
        this.getContentPane().add((Component)this.resolver, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
    }

    public ConflictResolutionDialog(Component component) {
        super(JOptionPane.getFrameForComponent(component), true);
        this.build();
    }

    public ConflictResolver getConflictResolver() {
        return this.resolver;
    }

    class ApplyResolutionAction
    extends AbstractAction {
        public ApplyResolutionAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts and close the dialog"));
            this.putValue("Name", I18n.tr("Apply Resolution"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "conflict"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray;
            int n;
            if (!(ConflictResolutionDialog.this.resolver.isResolvedCompletely() || (n = JOptionPane.showOptionDialog(null, I18n.tr("<html>You didn''t finish to resolve all conflicts.<br>Click <strong>{0}</strong> to apply already resolved conflicts anyway.<br>You can resolve the remaining conflicts later.<br>Click <strong>{1}</strong> to return to resolving conflicts.</html>", (objectArray = new Object[]{I18n.tr("Apply partial resolutions"), I18n.tr("Continue resolving")})[0].toString(), objectArray[1].toString()), I18n.tr("Warning"), 0, 2, null, objectArray, objectArray[1])) != 1 && n != -1)) {
                return;
            }
            try {
                objectArray = ConflictResolutionDialog.this.resolver.buildResolveCommand();
                Main.main.undoRedo.add((Command)objectArray);
            }
            catch (OperationCancelledException operationCancelledException) {
                // empty catch block
            }
            ConflictResolutionDialog.this.setVisible(false);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution and close the dialog"));
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("", "cancel"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConflictResolutionDialog.this.setVisible(false);
        }
    }
}

