/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JComponent;

public class JMultilineLabel
extends JComponent {
    private String text;
    private int maxWidth = Integer.MAX_VALUE;
    private boolean justify;
    private final FontRenderContext frc = new FontRenderContext(null, false, false);

    public JMultilineLabel(String string) {
        this.setText(string);
    }

    private void morph() {
        this.revalidate();
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        String string2 = this.text;
        this.text = string;
        this.firePropertyChange("text", string2, this.text);
        if (string2 == null ? string != null : !string2.equals(string)) {
            this.morph();
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.maxWidth;
        this.maxWidth = n;
        this.firePropertyChange("maxWidth", n2, this.maxWidth);
        if (n2 != this.maxWidth) {
            this.morph();
        }
    }

    public boolean isJustified() {
        return this.justify;
    }

    public void setJustified(boolean bl) {
        boolean bl2 = this.justify;
        this.justify = bl;
        this.firePropertyChange("justified", bl2, this.justify);
        if (bl2 != this.justify) {
            this.repaint();
        }
    }

    public Dimension getPreferredSize() {
        return this.paintOrGetSize(null, this.getMaxWidth());
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintOrGetSize((Graphics2D)graphics, this.getWidth());
    }

    private Dimension paintOrGetSize(Graphics2D graphics2D, int n) {
        Insets insets = this.getInsets();
        float f = insets.left + insets.right;
        float f2 = insets.left;
        float f3 = insets.top;
        if ((n -= insets.left + insets.right) > 0 && this.text != null && this.text.length() > 0) {
            String[] stringArray;
            for (String string : stringArray = this.getText().split("\n")) {
                if (string.length() == 0) {
                    string = " ";
                }
                AttributedString attributedString = new AttributedString(string);
                attributedString.addAttribute(TextAttribute.FONT, this.getFont());
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, this.frc);
                float f4 = 0.0f;
                while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(n);
                    if (graphics2D != null && this.isJustified() && (double)textLayout.getVisibleAdvance() > 0.8 * (double)n) {
                        textLayout = textLayout.getJustifiedLayout(n);
                    }
                    if (graphics2D != null) {
                        textLayout.draw(graphics2D, f2, f3 + textLayout.getAscent());
                    }
                    f3 += textLayout.getDescent() + textLayout.getLeading() + textLayout.getAscent();
                    f4 = Math.max(f4, textLayout.getVisibleAdvance());
                }
                f += f4;
            }
        }
        return new Dimension((int)Math.ceil(f), (int)Math.ceil(f3) + insets.bottom);
    }
}

