/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.tools.I18n;

public class SwissGrid
implements Projection {
    public EastNorth latlon2eastNorth(LatLon latLon) {
        double d = 3600.0 * latLon.lat();
        double d2 = 3600.0 * latLon.lon();
        double d3 = (d - 169028.66) / 10000.0;
        double d4 = (d2 - 26782.5) / 10000.0;
        double d5 = Math.pow(d4, 2.0);
        double d6 = Math.pow(d3, 2.0);
        double d7 = 200147.07 + 308807.95 * d3 + 3745.25 * d5 + 76.63 * d6 - 194.56 * d5 * d3 + 119.79 * Math.pow(d3, 3.0);
        double d8 = 600072.37 + 211455.93 * d4 - 10938.51 * d4 * d3 - 0.36 * d4 * d6 - 44.54 * Math.pow(d4, 3.0);
        return new EastNorth(d8, d7);
    }

    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        double d = (eastNorth.east() - 600000.0) / 1000000.0;
        double d2 = (eastNorth.north() - 200000.0) / 1000000.0;
        double d3 = Math.pow(d2, 2.0);
        double d4 = Math.pow(d, 2.0);
        double d5 = 2.6779094 + 4.728982 * d + 0.791484 * d * d2 + 0.1306 * d * d3 - 0.0436 * Math.pow(d, 3.0);
        double d6 = 16.9023892 + 3.238272 * d2 - 0.270978 * d4 - 0.002528 * d3 - 0.0447 * d4 * d2 - 0.014 * Math.pow(d2, 3.0);
        double d7 = d5 * 100.0 / 36.0;
        double d8 = d6 * 100.0 / 36.0;
        return new LatLon(d8, d7);
    }

    public String toString() {
        return I18n.tr("Swiss Grid (Switzerland)");
    }

    public String toCode() {
        return "EPSG:21781";
    }

    public String getCacheDirectoryName() {
        return "swissgrid";
    }

    public ProjectionBounds getWorldBounds() {
        Bounds bounds = this.getWorldBoundsLatLon();
        return new ProjectionBounds(this.latlon2eastNorth(bounds.min), this.latlon2eastNorth(bounds.max));
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(45.7, 5.7), new LatLon(47.9, 10.6));
    }
}

