/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OsmPrimitiveType {
    NODE("node", I18n.tr("node"), I18n.tr("nodes")),
    WAY("way", I18n.tr("way"), I18n.tr("ways")),
    RELATION("relation", I18n.tr("relation"), I18n.tr("relations")),
    CHANGESET("changeset", I18n.tr("changeset"), I18n.tr("changesets"));

    private String apiTypeName;
    private String localizedDisplayNameSingular;
    private String localizedDisplayNamePlural;

    private OsmPrimitiveType(String string2, String string3, String string4) {
        this.apiTypeName = string2;
        this.localizedDisplayNameSingular = string3;
        this.localizedDisplayNamePlural = string4;
    }

    public String getAPIName() {
        return this.apiTypeName;
    }

    public String getLocalizedDisplayNameSingular() {
        return this.localizedDisplayNameSingular;
    }

    public String getLocalizedDisplayNamePlural() {
        return this.localizedDisplayNamePlural;
    }

    public static OsmPrimitiveType fromApiTypeName(String string) {
        for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.values()) {
            if (!osmPrimitiveType.getAPIName().equals(string)) continue;
            return osmPrimitiveType;
        }
        throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' is not a valid type name, got ''{1}''", "typeName", string));
    }

    public static OsmPrimitiveType from(OsmPrimitive osmPrimitive) {
        return OsmPrimitiveType.from(osmPrimitive.getClass());
    }

    public static OsmPrimitiveType from(Class clazz) {
        if (clazz.equals(Node.class)) {
            return NODE;
        }
        if (clazz.equals(Way.class)) {
            return WAY;
        }
        if (clazz.equals(Relation.class)) {
            return RELATION;
        }
        if (clazz.equals(Changeset.class)) {
            return CHANGESET;
        }
        throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' is not an acceptable class, got ''{1}''", "cls", clazz.toString()));
    }
}

