/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.I18n;

public final class Node
extends OsmPrimitive {
    private CachedLatLon coor;
    private static LatLon.CoordinateFormat mCord;

    public final void setCoor(LatLon latLon) {
        if (latLon != null) {
            if (this.coor == null) {
                this.coor = new CachedLatLon(latLon);
            } else {
                this.coor.setCoor(latLon);
            }
        }
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final void setEastNorth(EastNorth eastNorth) {
        if (eastNorth != null) {
            if (this.coor != null) {
                this.coor.setEastNorth(eastNorth);
            } else {
                this.coor = new CachedLatLon(eastNorth);
            }
        }
    }

    public final EastNorth getEastNorth() {
        return this.coor != null ? this.coor.getEastNorth() : null;
    }

    public static LatLon.CoordinateFormat getCoordinateFormat() {
        return mCord;
    }

    public static void setCoordinateFormat() {
        try {
            mCord = LatLon.CoordinateFormat.valueOf(Main.pref.get("coordinates"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            mCord = LatLon.CoordinateFormat.DECIMAL_DEGREES;
        }
    }

    public Node(long l) {
        this.id = l;
        this.incomplete = true;
    }

    public Node(Node node) {
        this.cloneFrom(node);
    }

    public Node(LatLon latLon) {
        this.setCoor(latLon);
    }

    public Node(EastNorth eastNorth) {
        this.setEastNorth(eastNorth);
    }

    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    public void cloneFrom(OsmPrimitive osmPrimitive) {
        super.cloneFrom(osmPrimitive);
        this.setCoor(((Node)osmPrimitive).coor);
    }

    public String toString() {
        if (this.coor == null) {
            return "{Node id=" + this.id + "}";
        }
        return "{Node id=" + this.id + ",version=" + this.version + ",lat=" + this.coor.lat() + ",lon=" + this.coor.lon() + "}";
    }

    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null || !(osmPrimitive instanceof Node)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(osmPrimitive)) {
            return false;
        }
        Node node = (Node)osmPrimitive;
        if (this.coor == null && node.coor == null) {
            return true;
        }
        if (this.coor != null && node.coor != null) {
            return this.coor.equals(node.coor);
        }
        return false;
    }

    public int compareTo(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Node ? Long.valueOf(this.id).compareTo(osmPrimitive.id) : 1;
    }

    public String getName() {
        String string;
        if (this.incomplete) {
            string = I18n.tr("incomplete");
        } else {
            string = this.get("name");
            if (string == null) {
                string = this.id == 0L ? I18n.tr("node") : "" + this.id;
            }
            string = string + " (" + this.coor.latToString(mCord) + ", " + this.coor.lonToString(mCord) + ")";
        }
        return string;
    }

    static {
        Node.setCoordinateFormat();
    }
}

