/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.Coordinate;
import org.openstreetmap.josm.tools.I18n;

public class LatLon
extends Coordinate {
    private static DecimalFormat cDmsMinuteFormatter = new DecimalFormat("00");
    private static DecimalFormat cDmsSecondFormatter = new DecimalFormat("00.0");
    private static DecimalFormat cDdFormatter = new DecimalFormat("###0.0000");

    public static String dms(double d) {
        double d2 = Math.abs(d);
        int n = (int)d2;
        double d3 = (d2 - (double)n) * 60.0;
        int n2 = (int)d3;
        double d4 = (d3 - (double)n2) * 60.0;
        return n + "\u00b0" + cDmsMinuteFormatter.format(n2) + "'" + cDmsSecondFormatter.format(d4) + "\"";
    }

    public LatLon(double d, double d2) {
        super(d2, d);
    }

    public LatLon(LatLon latLon) {
        super(latLon.lon(), latLon.lat());
    }

    public double lat() {
        return this.y;
    }

    public String latToString(CoordinateFormat coordinateFormat) {
        switch (coordinateFormat) {
            case DECIMAL_DEGREES: {
                return cDdFormatter.format(this.y);
            }
            case DEGREES_MINUTES_SECONDS: {
                return LatLon.dms(this.y) + (this.y < 0.0 ? I18n.tr("S") : I18n.tr("N"));
            }
        }
        return "ERR";
    }

    public double lon() {
        return this.x;
    }

    public String lonToString(CoordinateFormat coordinateFormat) {
        switch (coordinateFormat) {
            case DECIMAL_DEGREES: {
                return cDdFormatter.format(this.x);
            }
            case DEGREES_MINUTES_SECONDS: {
                return LatLon.dms(this.x) + (this.x < 0.0 ? I18n.tr("W") : I18n.tr("E"));
            }
        }
        return "ERR";
    }

    public boolean equalsEpsilon(LatLon latLon) {
        return Math.abs(this.lat() - latLon.lat()) <= 1.0E-12 && Math.abs(this.lon() - latLon.lon()) <= 1.0E-12;
    }

    public boolean isOutSideWorld() {
        Bounds bounds = Main.proj.getWorldBoundsLatLon();
        return this.lat() < bounds.min.lat() || this.lat() > bounds.max.lat() || this.lon() < bounds.min.lon() || this.lon() > bounds.max.lon();
    }

    public boolean isWithin(Bounds bounds) {
        return this.lat() >= bounds.min.lat() && this.lat() <= bounds.max.lat() && this.lon() > bounds.min.lon() && this.lon() < bounds.max.lon();
    }

    public double greatCircleDistance(LatLon latLon) {
        return Math.acos(Math.sin(Math.toRadians(this.lat())) * Math.sin(Math.toRadians(latLon.lat())) + Math.cos(Math.toRadians(this.lat())) * Math.cos(Math.toRadians(latLon.lat())) * Math.cos(Math.toRadians(latLon.lon() - this.lon()))) * 6378135.0;
    }

    public double heading(LatLon latLon) {
        double d;
        if (latLon.lat() == this.lat()) {
            d = latLon.lon() > this.lon() ? 1.5707963267948966 : 4.71238898038469;
        } else {
            d = Math.atan((latLon.lon() - this.lon()) / (latLon.lat() - this.lat()));
            if (d < 0.0) {
                d += Math.PI;
            }
            if (latLon.lon() < this.lon()) {
                d += Math.PI;
            }
        }
        return d;
    }

    public String toDisplayString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(5);
        return "lat=" + numberFormat.format(this.lat()) + "\u00c2\u00b0, lon=" + numberFormat.format(this.lon()) + "\u00c2\u00b0";
    }

    public LatLon interpolate(LatLon latLon, double d) {
        return new LatLon(this.lat() + d * (latLon.lat() - this.lat()), this.lon() + d * (latLon.lon() - this.lon()));
    }

    public LatLon getCenter(LatLon latLon) {
        return new LatLon((this.lat() + latLon.lat()) / 2.0, (this.lon() + latLon.lon()) / 2.0);
    }

    public String toString() {
        return "LatLon[lat=" + this.lat() + ",lon=" + this.lon() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CoordinateFormat {
        DECIMAL_DEGREES{

            public String toString() {
                return I18n.tr("Decimal Degrees");
            }
        }
        ,
        DEGREES_MINUTES_SECONDS{

            public String toString() {
                return I18n.tr("Degrees Minutes Seconds");
            }
        };

    }
}

