/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.conflict.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.TagMergeItem;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagConflictResolveCommand
extends ConflictResolveCommand {
    private static final Logger logger = Logger.getLogger(TagConflictResolveCommand.class.getName());
    private Conflict<OsmPrimitive> conflict;
    private final List<TagMergeItem> mergeItems;

    public int getNumDecidedConflicts() {
        int n = 0;
        for (TagMergeItem tagMergeItem : this.mergeItems) {
            if (tagMergeItem.getMergeDecision().equals((Object)MergeDecisionType.UNDECIDED)) continue;
            ++n;
        }
        return n;
    }

    public TagConflictResolveCommand(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2, List<TagMergeItem> list) {
        this.conflict = new Conflict<OsmPrimitive>(osmPrimitive, osmPrimitive2);
        this.mergeItems = list;
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Resolve {0} tag conflicts in {1} {2}", this.getNumDecidedConflicts(), OsmPrimitiveType.from(this.conflict.getMy()).getLocalizedDisplayNameSingular(), this.conflict.getMy().id), ImageProvider.get("data", "object"), 0));
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        for (TagMergeItem tagMergeItem : this.mergeItems) {
            if (tagMergeItem.getMergeDecision().equals((Object)MergeDecisionType.UNDECIDED)) continue;
            tagMergeItem.applyToMyPrimitive(this.conflict.getMy());
        }
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.conflict.getMy());
    }
}

