/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.MergeDecisionType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinateConflictResolveCommand
extends ConflictResolveCommand {
    private Conflict<Node> conflict;
    private final MergeDecisionType decision;

    public CoordinateConflictResolveCommand(Node node, Node node2, MergeDecisionType mergeDecisionType) {
        this.conflict = new Conflict<Node>(node, node2);
        this.decision = mergeDecisionType;
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Resolve conflicts in coordinates in {0}", this.conflict.getMy().id), ImageProvider.get("data", "object"), 0));
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (!this.decision.equals((Object)MergeDecisionType.KEEP_MINE)) {
            if (this.decision.equals((Object)MergeDecisionType.KEEP_THEIR)) {
                Node node = this.conflict.getMy();
                Node node2 = this.conflict.getTheir();
                node.setCoor(node2.getCoor());
            } else {
                throw new IllegalStateException(I18n.tr("cannot resolve undecided conflict"));
            }
        }
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.conflict.getMy());
    }
}

