/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePropertyCommand
extends Command {
    private final List<OsmPrimitive> objects = new LinkedList<OsmPrimitive>();
    private final String key;
    private final String value;

    public ChangePropertyCommand(Collection<? extends OsmPrimitive> collection, String string, String string2) {
        this.key = string;
        this.value = string2;
        if (string2 == null) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive.get(string) == null) continue;
                this.objects.add(osmPrimitive);
            }
        } else {
            for (OsmPrimitive osmPrimitive : collection) {
                String string3 = osmPrimitive.get(string);
                if (string3 != null && string2.equals(string3)) continue;
                this.objects.add(osmPrimitive);
            }
        }
    }

    public ChangePropertyCommand(OsmPrimitive osmPrimitive, String string, String string2) {
        this.key = string;
        this.value = string2;
        String string3 = osmPrimitive.get(string);
        if (string2 == null && string3 != null || string2 != null && (string3 == null || !string2.equals(string3))) {
            this.objects.add(osmPrimitive);
        }
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (this.value == null) {
            for (OsmPrimitive osmPrimitive : this.objects) {
                osmPrimitive.modified = true;
                osmPrimitive.remove(this.key);
            }
        } else {
            for (OsmPrimitive osmPrimitive : this.objects) {
                osmPrimitive.modified = true;
                osmPrimitive.put(this.key, this.value);
            }
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.addAll(this.objects);
    }

    @Override
    public MutableTreeNode description() {
        String string;
        Object object;
        if (this.objects.size() == 1) {
            object = new NameVisitor();
            this.objects.iterator().next().visit((Visitor)object);
            string = this.value == null ? I18n.tr("Remove \"{0}\" for {1} ''{2}''", this.key, I18n.tr(((NameVisitor)object).className), ((NameVisitor)object).name) : I18n.tr("Set {0}={1} for {2} ''{3}''", this.key, this.value, I18n.tr(((NameVisitor)object).className), ((NameVisitor)object).name);
        } else {
            string = this.value == null ? I18n.tr("Remove \"{0}\" for {1} {2}", this.key, this.objects.size(), I18n.trn("object", "objects", this.objects.size())) : I18n.tr("Set {0}={1} for {2} {3}", this.key, this.value, this.objects.size(), I18n.trn("object", "objects", this.objects.size()));
        }
        object = new DefaultMutableTreeNode(new JLabel(string, ImageProvider.get("data", "key"), 0));
        if (this.objects.size() == 1) {
            return object;
        }
        NameVisitor nameVisitor = new NameVisitor();
        for (OsmPrimitive osmPrimitive : this.objects) {
            osmPrimitive.visit(nameVisitor);
            ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode(nameVisitor.toLabel()));
        }
        return object;
    }
}

