/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSelectionAction
extends JosmAction {
    protected void handlePrimitiveGoneException(long l) {
        MultiFetchServerObjectReader multiFetchServerObjectReader = new MultiFetchServerObjectReader();
        multiFetchServerObjectReader.append(Main.main.createOrGetEditLayer().data, l);
        DataSet dataSet = null;
        try {
            dataSet = multiFetchServerObjectReader.parseOsm();
        }
        catch (Exception exception) {
            this.handleUpdateException(exception);
            return;
        }
        Main.map.mapView.getEditLayer().mergeFrom(dataSet);
    }

    protected void handleUpdateException(Exception exception) {
        exception.printStackTrace();
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Failed to update the selected primitives."), I18n.tr("Update failed"), 0);
    }

    protected void handleMissingPrimitive(long l) {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not find primitive with id {0} in the current dataset", new Long(l).toString()), I18n.tr("Missing primitive"), 0);
    }

    public void updatePrimitives(final Collection<OsmPrimitive> collection) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UpdatePrimitiveTask
        extends PleaseWaitRunnable {
            private DataSet ds;
            private boolean cancelled;
            Exception lastException;

            protected void setIndeterminateEnabled(final boolean bl) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        Main.pleaseWaitDlg.setIndeterminate(bl);
                    }
                });
            }

            public UpdatePrimitiveTask() {
                super("Update primitives", false);
                this.cancelled = false;
            }

            protected void showLastException() {
                String string = this.lastException.getMessage();
                if (string == null) {
                    string = this.lastException.toString();
                }
                JOptionPane.showMessageDialog(Main.map, string, I18n.tr("Error"), 0);
            }

            @Override
            protected void cancel() {
                this.cancelled = true;
                OsmApi.getOsmApi().cancel();
            }

            @Override
            protected void finish() {
                if (this.cancelled) {
                    return;
                }
                if (this.lastException != null) {
                    this.showLastException();
                    return;
                }
                if (this.ds != null) {
                    Main.map.mapView.getEditLayer().mergeFrom(this.ds);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void realRun() throws SAXException, IOException, OsmTransferException {
                this.setIndeterminateEnabled(true);
                try {
                    MultiFetchServerObjectReader multiFetchServerObjectReader = new MultiFetchServerObjectReader();
                    multiFetchServerObjectReader.append(collection);
                    this.ds = multiFetchServerObjectReader.parseOsm();
                }
                catch (Exception exception) {
                    if (this.cancelled) {
                        return;
                    }
                    this.lastException = exception;
                }
                finally {
                    this.setIndeterminateEnabled(false);
                }
            }
        }
        Main.worker.submit(new UpdatePrimitiveTask());
    }

    public void updatePrimitive(long l) {
        OsmPrimitive osmPrimitive = Main.map.mapView.getEditLayer().data.getPrimitiveById(l);
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        hashSet.add(osmPrimitive);
        this.updatePrimitives(hashSet);
    }

    public UpdateSelectionAction() {
        super(I18n.tr("Update Selection"), "updateselection", I18n.tr("Updates the currently selected primitives from the server"), Shortcut.registerShortcut("file:updateselection", I18n.tr("Update Selection"), 85, 15), true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        if (collection.size() == 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no selected primitives to update."), I18n.tr("Selection empty"), 1);
            return;
        }
        this.updatePrimitives(collection);
    }
}

