/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class ReverseWayAction
extends JosmAction {
    public ReverseWayAction() {
        super(I18n.tr("Reverse Ways"), "wayflip", I18n.tr("Reverse the direction of all selected ways."), Shortcut.registerShortcut("tools:reverse", I18n.tr("Tool: {0}", I18n.tr("Reverse Ways")), 82, 3), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final LinkedList linkedList = new LinkedList();
        new AbstractVisitor(){

            public void visit(Node node) {
            }

            public void visit(Way way) {
                linkedList.add(way);
            }

            public void visit(Relation relation) {
            }

            public void visitAll() {
                for (OsmPrimitive osmPrimitive : Main.ds.getSelected()) {
                    osmPrimitive.visit(this);
                }
            }
        }.visitAll();
        if (linkedList.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one way."));
            return;
        }
        boolean bl = false;
        ReverseWayTagCorrector reverseWayTagCorrector = new ReverseWayTagCorrector();
        LinkedList<Command> linkedList2 = new LinkedList<Command>();
        for (Way way : linkedList) {
            Way way2 = new Way(way);
            Collections.reverse(way2.nodes);
            if (Main.pref.getBoolean("tag-correction.reverse-way", true)) {
                try {
                    Collection<Command> collection = reverseWayTagCorrector.execute(way, way2);
                    bl = bl || collection != null && !collection.isEmpty();
                    linkedList2.addAll(collection);
                }
                catch (UserCancelException userCancelException) {
                    return;
                }
            }
            linkedList2.add(new ChangeCommand(way, way2));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Reverse ways"), linkedList2));
        if (bl) {
            DataSet.fireSelectionChanged(Main.ds.getSelected());
        }
        Main.map.repaint();
    }
}

