/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageProvider {
    private static Map<String, Image> cache = new HashMap<String, Image>();
    public static final List<ClassLoader> sources = new LinkedList<ClassLoader>();
    static final double DEGREE_90 = 1.5707963267948966;

    public static ImageIcon get(String string, String string2) {
        ImageIcon imageIcon = ImageProvider.getIfAvailable(string, string2);
        if (imageIcon == null) {
            String string3 = string2.indexOf(46) != -1 ? "" : ".png";
            throw new NullPointerException("/images/" + string + string2 + string3 + " not found");
        }
        return imageIcon;
    }

    public static ImageIcon getIfAvailable(String string, String string2) {
        return ImageProvider.getIfAvailable((Collection<String>)null, null, string, string2);
    }

    public static final ImageIcon getIfAvailable(String[] stringArray, String string, String string2, String string3) {
        return ImageProvider.getIfAvailable(Arrays.asList(stringArray), string, string2, string3);
    }

    public static ImageIcon getIfAvailable(Collection<String> collection, String string, String string2, String string3) {
        Image image;
        String string4;
        if (string3 == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "";
        } else if (!string2.equals("")) {
            string2 = string2 + "/";
        }
        String string5 = string3.indexOf(46) != -1 ? "" : ".png";
        String string6 = string4 = string2 + string3 + string5;
        if (collection != null && collection.size() > 0) {
            string6 = "id:" + string + ":" + string4;
        }
        if ((image = cache.get(string6)) == null) {
            URL uRL = ImageProvider.getImageUrl(string4, collection);
            if (uRL == null) {
                return null;
            }
            image = Toolkit.getDefaultToolkit().createImage(uRL);
            cache.put(string6, image);
        }
        return new ImageIcon(image);
    }

    private static URL getImageUrl(String string, String string2) {
        if (string.startsWith("resource://")) {
            String string3 = string.substring("resource://".length());
            for (ClassLoader classLoader : sources) {
                URL uRL = classLoader.getResource(string3 + string2);
                if (uRL == null) continue;
                return uRL;
            }
        } else {
            try {
                File file = new File(string, string2);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private static URL getImageUrl(String string, Collection<String> collection) {
        URL uRL;
        if (collection != null) {
            for (String string2 : collection) {
                uRL = ImageProvider.getImageUrl(string2, string);
                if (uRL == null) continue;
                return uRL;
            }
        }
        if ((uRL = ImageProvider.getImageUrl(Main.pref.getPreferencesDir() + "images", string)) != null) {
            return uRL;
        }
        uRL = ImageProvider.getImageUrl("resource://images/", string);
        if (uRL != null) {
            return uRL;
        }
        for (String string2 : Main.pref.getAllPossiblePreferenceDirs()) {
            uRL = ImageProvider.getImageUrl(string2 + "images", string);
            if (uRL != null) {
                return uRL;
            }
            uRL = ImageProvider.getImageUrl(string2, string);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    public static ImageIcon get(String string) {
        return ImageProvider.get("", string);
    }

    public static Cursor getCursor(String string, String string2) {
        ImageIcon imageIcon = ImageProvider.get("cursor", string);
        if (string2 != null) {
            imageIcon = ImageProvider.overlay(imageIcon, "cursor/modifier/" + string2, OverlayPosition.SOUTHEAST);
        }
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), string.equals("crosshair") ? new Point(10, 10) : new Point(3, 2), "Cursor");
        return cursor;
    }

    public static ImageIcon overlay(Icon icon, String string, OverlayPosition overlayPosition) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        ImageIcon imageIcon = ImageProvider.get(string);
        int n3 = imageIcon.getIconWidth();
        int n4 = imageIcon.getIconHeight();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        int n5 = 0;
        int n6 = 0;
        switch (overlayPosition) {
            case NORTHWEST: {
                n5 = 0;
                n6 = 0;
                break;
            }
            case NORTHEAST: {
                n5 = n - n3;
                n6 = 0;
                break;
            }
            case SOUTHWEST: {
                n5 = 0;
                n6 = n2 - n4;
                break;
            }
            case SOUTHEAST: {
                n5 = n - n3;
                n6 = n2 - n4;
            }
        }
        imageIcon.paintIcon(null, graphics2D, n5, n6);
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon createRotatedImage(Component component, Icon icon, double d) {
        int n;
        int n2;
        double d2 = d % 360.0;
        if (d != 0.0 && d2 == 0.0) {
            d2 = 360.0;
        }
        double d3 = d2 % 90.0;
        if (d2 != 0.0 && d3 == 0.0) {
            d3 = 90.0;
        }
        double d4 = Math.toRadians(d3);
        int n3 = icon.getIconWidth();
        int n4 = icon.getIconHeight();
        if (d2 >= 0.0 && d2 <= 90.0 || d2 > 180.0 && d2 <= 270.0) {
            n2 = (int)((double)n3 * Math.sin(1.5707963267948966 - d4) + (double)n4 * Math.sin(d4));
            n = (int)((double)n3 * Math.sin(d4) + (double)n4 * Math.sin(1.5707963267948966 - d4));
        } else {
            n2 = (int)((double)n4 * Math.sin(1.5707963267948966 - d4) + (double)n3 * Math.sin(d4));
            n = (int)((double)n4 * Math.sin(d4) + (double)n3 * Math.sin(1.5707963267948966 - d4));
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        Graphics graphics = bufferedImage.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n5 = n3 / 2;
        int n6 = n4 / 2;
        graphics2D.translate(n2 / 2, n / 2);
        graphics2D.rotate(Math.toRadians(d2));
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        icon.paintIcon(component, graphics2D, -n5, -n6);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    static {
        try {
            sources.add(ClassLoader.getSystemClassLoader());
            sources.add(MainApplication.class.getClassLoader());
        }
        catch (SecurityException securityException) {
            sources.add(ImageProvider.class.getClassLoader());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OverlayPosition {
        NORTHWEST,
        NORTHEAST,
        SOUTHWEST,
        SOUTHEAST;

    }
}

