/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInformation {
    public File file = null;
    public String name = null;
    public int mainversion = 0;
    public String className = null;
    public String requires = null;
    public String link = null;
    public String description = null;
    public boolean early = false;
    public String author = null;
    public int stage = 50;
    public String version = null;
    public String downloadlink = null;
    public List<URL> libraries = new LinkedList<URL>();
    public final Map<String, String> attr = new TreeMap<String, String>();
    static PluginInformation currentPluginInitialization = null;

    public PluginInformation(File file) {
        this(file, file.getName().substring(0, file.getName().length() - 4));
    }

    public PluginInformation(File file, String string) {
        this.name = string;
        this.file = file;
        try {
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
            Manifest manifest = jarInputStream.getManifest();
            if (manifest == null) {
                throw new IOException(file + " contains no manifest.");
            }
            this.scanManifest(manifest);
            this.libraries.add(0, PluginInformation.fileToURL(file));
            jarInputStream.close();
        }
        catch (IOException iOException) {
            throw new PluginException(null, string, iOException);
        }
    }

    public PluginInformation(InputStream inputStream, String string) {
        this.name = string;
        try {
            Manifest manifest = new Manifest();
            manifest.read(inputStream);
            this.scanManifest(manifest);
        }
        catch (IOException iOException) {
            throw new PluginException(null, string, iOException);
        }
    }

    private void scanManifest(Manifest manifest) {
        String string = Main.getLanguageCode() + "_";
        Attributes attributes = manifest.getMainAttributes();
        this.className = attributes.getValue("Plugin-Class");
        String string2 = attributes.getValue(string + "Plugin-Link");
        if (string2 == null) {
            string2 = attributes.getValue("Plugin-Link");
        }
        this.link = string2;
        this.requires = attributes.getValue("Plugin-Requires");
        string2 = attributes.getValue(string + "Plugin-Description");
        if (string2 == null && (string2 = attributes.getValue("Plugin-Description")) != null) {
            string2 = I18n.tr(string2);
        }
        this.description = string2;
        this.early = Boolean.parseBoolean(attributes.getValue("Plugin-Early"));
        String string3 = attributes.getValue("Plugin-Stage");
        this.stage = string3 == null ? 50 : Integer.parseInt(string3);
        this.version = attributes.getValue("Plugin-Version");
        try {
            this.mainversion = Integer.parseInt(attributes.getValue("Plugin-Mainversion"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.author = attributes.getValue("Author");
        String string4 = attributes.getValue(Attributes.Name.CLASS_PATH);
        if (string4 != null) {
            for (String string5 : string4.split(" ")) {
                File file = new File(string5).isAbsolute() ? new File(string5) : new File(this.file.getParent(), string5);
                this.libraries.add(PluginInformation.fileToURL(file));
            }
        }
        for (Object e : attributes.keySet()) {
            this.attr.put(e.toString(), attributes.getValue(e.toString()));
        }
    }

    public String getLinkDescription() {
        String string;
        String string2 = string = this.description == null ? I18n.tr("no description available") : this.description;
        if (this.link != null) {
            string = string + " <A HREF=\"" + this.link + "\">" + I18n.tr("More details") + "</A>";
        }
        return string;
    }

    public PluginProxy load(Class<?> clazz) {
        try {
            currentPluginInitialization = this;
            return new PluginProxy(clazz.newInstance(), this);
        }
        catch (Exception exception) {
            throw new PluginException(null, this.name, exception);
        }
    }

    public Class<?> loadClass(ClassLoader classLoader) {
        if (this.className == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(this.className, true, classLoader);
            return clazz;
        }
        catch (Exception exception) {
            throw new PluginException(null, this.name, exception);
        }
    }

    public static URL fileToURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static PluginInformation findPlugin(String string) throws PluginException {
        String string2 = string;
        string2 = string2.replaceAll("[-. ]", "");
        InputStream inputStream = PluginInformation.class.getResourceAsStream("/org/openstreetmap/josm/plugins/" + string2 + "/MANIFEST.MF");
        if (inputStream != null) {
            return new PluginInformation(inputStream, string);
        }
        Collection<String> collection = PluginInformation.getPluginLocations();
        for (String string3 : collection) {
            File file = new File(string3, string + ".jar");
            if (!file.exists()) continue;
            PluginInformation pluginInformation = new PluginInformation(file);
            return pluginInformation;
        }
        return null;
    }

    public static Collection<String> getPluginLocations() {
        Collection<String> collection = Main.pref.getAllPossiblePreferenceDirs();
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (String string : collection) {
            arrayList.add(string + "plugins");
        }
        return arrayList;
    }
}

