/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.awt.HeadlessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class OsmImporter
extends FileImporter {
    public OsmImporter() {
        super(new ExtensionFileFilter("osm,xml", "osm", I18n.tr("OSM Server Files") + " (*.osm *.xml)"));
    }

    public OsmImporter(ExtensionFileFilter extensionFileFilter) {
        super(extensionFileFilter);
    }

    public void importData(File file) throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.importData(fileInputStream, file);
        }
        catch (HeadlessException headlessException) {
            headlessException.printStackTrace();
            throw new IOException(I18n.tr("Could not read \"{0}\"", file.getName()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new IOException(I18n.tr("Could not read \"{0}\"", file.getName()));
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new IOException(I18n.tr("Could not read \"{0}\"", file.getName()));
        }
    }

    protected void importData(InputStream inputStream, File file) throws SAXException, IOException {
        OsmReader osmReader = OsmReader.parseDataSetOsm(inputStream, null, Main.pleaseWaitDlg);
        DataSet dataSet = osmReader.getDs();
        OsmDataLayer osmDataLayer = new OsmDataLayer(dataSet, file.getName(), file);
        Main.main.addLayer(osmDataLayer);
        osmDataLayer.fireDataChange();
        if (osmReader.getParseNotes().length() != 0) {
            String string = osmReader.getParseNotes();
            int n = 0;
            for (int i = 0; i < 5; ++i) {
                n = string.indexOf(10, n + 1);
            }
            n = n >= 0 ? n : string.length();
            JOptionPane.showMessageDialog(Main.parent, string.substring(0, n));
        }
    }
}

