/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.io.OsmImporter;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class OsmBzip2Importer
extends OsmImporter {
    public OsmBzip2Importer() {
        super(new ExtensionFileFilter("osm.bz2, osm.bz", "osm.bz2", I18n.tr("OSM Server Files bzip2 compressed") + " (*.osm.bz2 *.osm.bz)"));
    }

    public void importData(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        int n = bufferedInputStream.read();
        if (n != 66) {
            throw new IOException(I18n.tr("Invalid bz2 file."));
        }
        n = bufferedInputStream.read();
        if (n != 90) {
            throw new IOException(I18n.tr("Invalid bz2 file."));
        }
        CBZip2InputStream cBZip2InputStream = new CBZip2InputStream(bufferedInputStream);
        try {
            this.importData(cBZip2InputStream, file);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new IOException(I18n.tr("Could not read \"{0}\"", file.getName()));
        }
    }
}

