/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.download.OsmMapControl;
import org.openstreetmap.josm.gui.download.SizeButton;
import org.openstreetmap.josm.gui.download.SourceButton;
import org.openstreetmap.josm.tools.I18n;

public class SlippyMapChooser
extends JMapViewer
implements DownloadSelection {
    private DownloadDialog iGui;
    Point iSelectionRectStart;
    Point iSelectionRectEnd;
    private SizeButton iSizeButton = new SizeButton();
    private SourceButton iSourceButton = new SourceButton();
    private Dimension iDownloadDialogDimension;
    private Dimension iScreenSize;
    private TileSource[] sources = new TileSource[]{new OsmTileSource.Mapnik(), new OsmTileSource.TilesAtHome(), new OsmTileSource.CycleMap()};
    TileLoader cachedLoader = new OsmFileCacheTileLoader(this);
    TileLoader uncachedLoader = new OsmTileLoader(this);
    JPanel slipyyMapTabPanel;

    public SlippyMapChooser() {
        this.setZoomContolsVisible(false);
        this.setMapMarkerVisible(false);
        this.setMinimumSize(new Dimension(350, 175));
        this.setBounds(new Rectangle(this.getMinimumSize()));
        this.setFileCacheEnabled(Main.pref.getBoolean("slippy_map_chooser.file_cache", true));
        this.setMaxTilesInMemory(Main.pref.getInteger("slippy_map_chooser.max_tiles", 1000));
        String string = Main.pref.get("slippy_map_chooser.mapstyle", "mapnik");
        if (string.equals("osmarender")) {
            this.iSourceButton.setMapStyle(3);
            this.setTileSource(this.sources[1]);
        } else if (string.equals("cyclemap")) {
            this.iSourceButton.setMapStyle(4);
            this.setTileSource(this.sources[2]);
        } else if (!string.equals("mapnik")) {
            Main.pref.put("slippy_map_chooser.mapstyle", "mapnik");
        }
    }

    public void setMaxTilesInMemory(int n) {
        ((MemoryTileCache)this.getTileCache()).setCacheSize(n);
    }

    public void setFileCacheEnabled(boolean bl) {
        if (bl) {
            this.setTileLoader(this.cachedLoader);
        } else {
            this.setTileLoader(this.uncachedLoader);
        }
    }

    public void addGui(DownloadDialog downloadDialog) {
        this.iGui = downloadDialog;
        this.slipyyMapTabPanel = new JPanel();
        this.slipyyMapTabPanel.setLayout(new BorderLayout());
        this.slipyyMapTabPanel.add((Component)this, "Center");
        String string = "<b>Zoom:</b> Mousewheel, double click or Ctrl + Up/Down <b>Move map:</b> Hold right mousebutton and move mouse or use cursor keys. <b>Select:</b> Click.";
        this.slipyyMapTabPanel.add((Component)new JLabel("<html>" + I18n.tr(string) + "</html>"), "South");
        this.iGui.tabpane.add((Component)this.slipyyMapTabPanel, I18n.tr("Slippy map"));
        new OsmMapControl(this, this.slipyyMapTabPanel, this.iSizeButton, this.iSourceButton);
    }

    protected Point getTopLeftCoordinates() {
        return new Point(this.center.x - this.getWidth() / 2, this.center.y - this.getHeight() / 2);
    }

    public void paint(Graphics graphics) {
        try {
            super.paint(graphics);
            if (this.iSelectionRectStart != null && this.iSelectionRectEnd != null) {
                int n = 22 - this.zoom;
                Point point = this.getTopLeftCoordinates();
                int n2 = (this.iSelectionRectStart.x >> n) - point.x;
                int n3 = (this.iSelectionRectStart.y >> n) - point.y;
                int n4 = (this.iSelectionRectEnd.x >> n) - point.x;
                int n5 = (this.iSelectionRectEnd.y >> n) - point.y;
                int n6 = n4 - n2;
                int n7 = n5 - n3;
                graphics.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
                graphics.fillRect(n2, n3, n6, n7);
                graphics.setColor(Color.BLACK);
                graphics.drawRect(n2, n3, n6, n7);
            }
            this.iSizeButton.paint(graphics);
            this.iSourceButton.paint(graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void boundingBoxChanged(DownloadDialog downloadDialog) {
        if (downloadDialog.minlat == 0.0 && downloadDialog.minlon == 0.0 && downloadDialog.maxlat == 0.0 && downloadDialog.maxlon == 0.0) {
            return;
        }
        int n = OsmMercator.LatToY(downloadDialog.minlat, 22);
        int n2 = OsmMercator.LatToY(downloadDialog.maxlat, 22);
        int n3 = OsmMercator.LonToX(downloadDialog.minlon, 22);
        int n4 = OsmMercator.LonToX(downloadDialog.maxlon, 22);
        this.iSelectionRectStart = new Point(Math.min(n3, n4), Math.min(n, n2));
        this.iSelectionRectEnd = new Point(Math.max(n3, n4), Math.max(n, n2));
        MapMarkerDot mapMarkerDot = new MapMarkerDot(downloadDialog.minlat, downloadDialog.minlon);
        MapMarkerDot mapMarkerDot2 = new MapMarkerDot(downloadDialog.maxlat, downloadDialog.maxlon);
        Vector<MapMarker> vector = new Vector<MapMarker>(2);
        vector.add(mapMarkerDot);
        vector.add(mapMarkerDot2);
        this.setMapMarkerList(vector);
        this.setDisplayToFitMapMarkers();
        this.zoomOut();
    }

    public void setSelection(Point point, Point point2) {
        if (point == null || point2 == null) {
            return;
        }
        Point point3 = new Point(Math.max(point2.x, point.x), Math.max(point2.y, point.y));
        Point point4 = new Point(Math.min(point2.x, point.x), Math.min(point2.y, point.y));
        Point point5 = this.getTopLeftCoordinates();
        int n = 22 - this.zoom;
        Point point6 = new Point(point3.x + point5.x, point3.y + point5.y);
        Point point7 = new Point(point4.x + point5.x, point4.y + point5.y);
        point6.x <<= n;
        point6.y <<= n;
        point7.x <<= n;
        point7.y <<= n;
        this.iSelectionRectStart = point7;
        this.iSelectionRectEnd = point6;
        Point2D.Double double_ = this.getPosition(point3);
        Point2D.Double double_2 = this.getPosition(point4);
        this.iGui.minlat = Math.min(double_2.x, double_.x);
        this.iGui.minlon = Math.min(double_.y, double_2.y);
        this.iGui.maxlat = Math.max(double_2.x, double_.x);
        this.iGui.maxlon = Math.max(double_.y, double_2.y);
        this.iGui.boundingBoxChanged(this);
        this.repaint();
    }

    public void resizeSlippyMap() {
        Dimension dimension;
        Container container;
        if (this.iScreenSize == null) {
            container = this.iGui.getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent();
            this.iDownloadDialogDimension = container.getSize();
            this.iScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        if ((dimension = (container = this.iGui.getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent()).getSize()).equals(this.iDownloadDialogDimension)) {
            int n = this.iScreenSize.width * 90 / 100;
            int n2 = this.iScreenSize.height * 90 / 100;
            container.setBounds((this.iScreenSize.width - n) / 2, (this.iScreenSize.height - n2) / 2, n, n2);
        } else {
            int n = this.iDownloadDialogDimension.width;
            int n3 = this.iDownloadDialogDimension.height;
            container.setBounds((this.iScreenSize.width - n) / 2, (this.iScreenSize.height - n3) / 2, n, n3);
        }
        this.repaint();
    }

    public void toggleMapSource(int n) {
        this.tileCache = new MemoryTileCache();
        if (n == 2) {
            this.setTileSource(this.sources[0]);
            Main.pref.put("slippy_map_chooser.mapstyle", "mapnik");
        } else if (n == 4) {
            this.setTileSource(this.sources[2]);
            Main.pref.put("slippy_map_chooser.mapstyle", "cyclemap");
        } else {
            this.setTileSource(this.sources[1]);
            Main.pref.put("slippy_map_chooser.mapstyle", "osmarender");
        }
    }
}

