/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.Color;
import org.openstreetmap.josm.gui.conflict.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.TagMergeItem;
import org.openstreetmap.josm.gui.conflict.tags.TagMergeTableCellRenderer;
import org.openstreetmap.josm.tools.I18n;

public class MergedTableCellRenderer
extends TagMergeTableCellRenderer {
    public static final Color BGCOLOR_UNDECIDED = new Color(255, 197, 197);
    public static final Color BGCOLOR_MINE = new Color(217, 255, 217);
    public static final Color BGCOLOR_THEIR = new Color(217, 255, 217);
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);

    protected void setBackgroundColor(TagMergeItem tagMergeItem, boolean bl) {
        if (bl) {
            this.setBackground(BGCOLOR_SELECTED);
            return;
        }
        if (MergeDecisionType.KEEP_MINE.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setBackground(BGCOLOR_MINE);
        } else if (MergeDecisionType.KEEP_THEIR.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setBackground(BGCOLOR_THEIR);
        } else if (MergeDecisionType.UNDECIDED.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setBackground(BGCOLOR_UNDECIDED);
        }
    }

    protected void renderKey(TagMergeItem tagMergeItem, boolean bl) {
        this.setBackgroundColor(tagMergeItem, bl);
        if (MergeDecisionType.KEEP_MINE.equals((Object)tagMergeItem.getMergeDecision()) && tagMergeItem.getMyTagValue() == null) {
            this.setText(I18n.tr("<undefined>"));
            this.setToolTipText(I18n.tr("The merged dataset will not include a tag with key {0}", tagMergeItem.getKey()));
        } else if (MergeDecisionType.KEEP_THEIR.equals((Object)tagMergeItem.getMergeDecision()) && tagMergeItem.getTheirTagValue() == null) {
            this.setText(I18n.tr("<undefined>"));
            this.setToolTipText(I18n.tr("The merged dataset will not include a tag with key {0}", tagMergeItem.getKey()));
        } else if (MergeDecisionType.UNDECIDED.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setText("");
        } else {
            this.setText(tagMergeItem.getKey());
            this.setToolTipText(tagMergeItem.getKey());
        }
    }

    protected void renderValue(TagMergeItem tagMergeItem, boolean bl) {
        this.setBackgroundColor(tagMergeItem, bl);
        if (MergeDecisionType.KEEP_MINE.equals((Object)tagMergeItem.getMergeDecision()) && tagMergeItem.getMyTagValue() == null) {
            this.setText(I18n.tr("<undefined>"));
            this.setToolTipText(I18n.tr("The merged dataset will not include a tag with key {0}", tagMergeItem.getKey()));
        } else if (MergeDecisionType.KEEP_THEIR.equals((Object)tagMergeItem.getMergeDecision()) && tagMergeItem.getTheirTagValue() == null) {
            this.setText(I18n.tr("<undefined>"));
            this.setToolTipText(I18n.tr("The merged dataset will not include a tag with key {0}", tagMergeItem.getKey()));
        } else if (MergeDecisionType.UNDECIDED.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setText("");
        } else if (MergeDecisionType.KEEP_MINE.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setText(tagMergeItem.getMyTagValue());
            this.setToolTipText(tagMergeItem.getMyTagValue());
        } else if (MergeDecisionType.KEEP_THEIR.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setText(tagMergeItem.getTheirTagValue());
            this.setToolTipText(tagMergeItem.getTheirTagValue());
        }
    }
}

