/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.HelpAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.I18n;

public class MapScaler
extends JComponent
implements HelpAction.Helpful {
    private final NavigatableComponent mv;

    public MapScaler(NavigatableComponent navigatableComponent, Projection projection) {
        this.mv = navigatableComponent;
        this.setSize(100, 30);
        this.setOpaque(false);
    }

    public void paint(Graphics graphics) {
        LatLon latLon;
        LatLon latLon2 = this.mv.getLatLon(0, 0);
        double d = latLon2.greatCircleDistance(latLon = this.mv.getLatLon(100, 0));
        String string = d >= 2000.0 ? Math.round(d / 100.0) / 10L + " km" : (d >= 1.0 ? Math.round(d * 10.0) / 10L + " m" : "< 1 m");
        Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
        graphics.setColor(MapScaler.getColor());
        graphics.drawLine(0, 5, 99, 5);
        graphics.drawLine(0, 0, 0, 10);
        graphics.drawLine(99, 0, 99, 10);
        graphics.drawLine(49, 0, 49, 10);
        graphics.drawLine(24, 3, 24, 7);
        graphics.drawLine(74, 3, 74, 7);
        graphics.drawString(string, (int)(100.0 - rectangle2D.getWidth()), 23);
        graphics.drawString("0", 0, 23);
    }

    public static Color getColor() {
        return Main.pref.getColor(I18n.marktr("scale"), Color.white);
    }

    public String helpTopic() {
        return "MapView/Scaler";
    }
}

