/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;

public class BoundingXYVisitor
extends AbstractVisitor {
    public EastNorth min;
    public EastNorth max;

    public void visit(Node node) {
        this.visit(node.getEastNorth());
    }

    public void visit(Way way) {
        way.visitNodes(this);
    }

    public void visit(Relation relation) {
        for (RelationMember relationMember : relation.members) {
            if (relationMember.member instanceof Relation) continue;
            relationMember.member.visit(this);
        }
    }

    public void visit(EastNorth eastNorth) {
        if (eastNorth != null) {
            if (this.min == null) {
                this.min = eastNorth;
            } else if (eastNorth.east() < this.min.east() || eastNorth.north() < this.min.north()) {
                this.min = new EastNorth(Math.min(this.min.east(), eastNorth.east()), Math.min(this.min.north(), eastNorth.north()));
            }
            if (this.max == null) {
                this.max = eastNorth;
            } else if (eastNorth.east() > this.max.east() || eastNorth.north() > this.max.north()) {
                this.max = new EastNorth(Math.max(this.max.east(), eastNorth.east()), Math.max(this.max.north(), eastNorth.north()));
            }
        }
    }

    public Bounds getBounds() {
        if (this.min == null || this.max == null) {
            return null;
        }
        return new Bounds(Main.proj.eastNorth2latlon(this.min), Main.proj.eastNorth2latlon(this.max));
    }

    public void enlargeBoundingBox() {
        this.enlargeBoundingBox(0.002);
    }

    public void enlargeBoundingBox(double d) {
        if (this.min == null || this.max == null) {
            return;
        }
        LatLon latLon = Main.proj.eastNorth2latlon(this.min);
        this.min = Main.proj.latlon2eastNorth(new LatLon(latLon.lat() - d, latLon.lon() - d));
        LatLon latLon2 = Main.proj.eastNorth2latlon(this.max);
        this.max = Main.proj.latlon2eastNorth(new LatLon(latLon2.lat() + d, latLon2.lon() + d));
    }
}

