/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ExtrudeAction
extends MapMode
implements MapViewPaintable {
    private Mode mode = null;
    private long mouseDownTime = 0L;
    private WaySegment selectedSegment = null;
    private Color selectedColor;
    double xoff;
    double yoff;
    double distance;
    private Cursor oldCursor;
    private Point mousePos;
    private Point initialMousePos;
    private int initialMoveDelay = 200;

    public ExtrudeAction(MapFrame mapFrame) {
        super(I18n.tr("Extrude"), "extrude/extrude", I18n.tr("Create areas"), Shortcut.registerShortcut("mapmode:extrude", I18n.tr("Mode: {0}", I18n.tr("Extrude")), 88, 3), mapFrame, ExtrudeAction.getCursor("normal", "rectangle", 0));
        this.putValue("help", "Action/Extrude/Extrude");
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.selectedColor = Main.pref.getColor(I18n.marktr("selected"), Color.red);
    }

    private static Cursor getCursor(String string, String string2, int n) {
        try {
            return ImageProvider.getCursor(string, string2);
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(n);
        }
    }

    private void setCursor(Cursor cursor) {
        if (this.oldCursor == null) {
            this.oldCursor = Main.map.mapView.getCursor();
            Main.map.mapView.setCursor(cursor);
        }
    }

    private void restoreCursor() {
        if (this.oldCursor != null) {
            Main.map.mapView.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isVisibleDrawableLayer().booleanValue()) {
            return;
        }
        if (this.mode == Mode.select) {
            return;
        }
        if (this.mode == Mode.EXTRUDE && System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if ((mouseEvent.getModifiersEx() & 0x400) == 0) {
            return;
        }
        if (this.mode == Mode.EXTRUDE) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
        if (this.mousePos == null) {
            this.mousePos = mouseEvent.getPoint();
            return;
        }
        Main.map.mapView.repaint();
        this.mousePos = mouseEvent.getPoint();
    }

    public void paint(Graphics graphics, MapView mapView) {
        if (this.selectedSegment != null) {
            Node node = this.selectedSegment.way.nodes.get(this.selectedSegment.lowerIndex);
            Node node2 = this.selectedSegment.way.nodes.get(this.selectedSegment.lowerIndex + 1);
            EastNorth eastNorth = node.getEastNorth();
            EastNorth eastNorth2 = node2.getEastNorth();
            EastNorth eastNorth3 = mapView.getEastNorth(this.mousePos.x, this.mousePos.y);
            double d = ((eastNorth3.east() - eastNorth.east()) * (eastNorth2.east() - eastNorth.east()) + (eastNorth3.north() - eastNorth.north()) * (eastNorth2.north() - eastNorth.north())) / eastNorth2.distanceSq(eastNorth);
            EastNorth eastNorth4 = new EastNorth(eastNorth.east() + d * (eastNorth2.east() - eastNorth.east()), eastNorth.north() + d * (eastNorth2.north() - eastNorth.north()));
            this.distance = Main.proj.eastNorth2latlon(eastNorth4).greatCircleDistance(Main.proj.eastNorth2latlon(eastNorth3));
            Main.map.statusLine.setDist(this.distance);
            this.updateStatusLine();
            this.xoff = eastNorth3.east() - eastNorth4.east();
            this.yoff = eastNorth3.north() - eastNorth4.north();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(this.selectedColor);
            graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
            GeneralPath generalPath = new GeneralPath();
            Point point = mapView.getPoint(eastNorth);
            Point point2 = mapView.getPoint(eastNorth2);
            Point point3 = mapView.getPoint(eastNorth.add(this.xoff, this.yoff));
            Point point4 = mapView.getPoint(eastNorth2.add(this.xoff, this.yoff));
            generalPath.moveTo(point.x, point.y);
            generalPath.lineTo(point3.x, point3.y);
            generalPath.lineTo(point4.x, point4.y);
            generalPath.lineTo(point2.x, point2.y);
            generalPath.lineTo(point.x, point.y);
            graphics2D.draw(generalPath);
            graphics2D.setStroke(new BasicStroke(1.0f));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isVisibleDrawableLayer().booleanValue()) {
            return;
        }
        if (!((Boolean)this.getValue("active")).booleanValue()) {
            return;
        }
        if (mouseEvent.getButton() != 1) {
            return;
        }
        this.mouseDownTime = System.currentTimeMillis();
        this.selectedSegment = Main.map.mapView.getNearestWaySegment(mouseEvent.getPoint());
        this.mode = this.selectedSegment == null ? Mode.select : Mode.EXTRUDE;
        this.oldCursor = Main.map.mapView.getCursor();
        this.updateStatusLine();
        Main.map.mapView.addTemporaryLayer(this);
        Main.map.mapView.repaint();
        this.mousePos = mouseEvent.getPoint();
        this.initialMousePos = mouseEvent.getPoint();
        if (this.selectedSegment != null) {
            Main.ds.setSelected(this.selectedSegment.way);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isVisibleDrawableLayer().booleanValue()) {
            return;
        }
        this.restoreCursor();
        if (this.selectedSegment == null) {
            return;
        }
        if (this.mousePos.distance(this.initialMousePos) > 10.0) {
            Node node = this.selectedSegment.way.nodes.get(this.selectedSegment.lowerIndex);
            Node node2 = this.selectedSegment.way.nodes.get(this.selectedSegment.lowerIndex + 1);
            EastNorth eastNorth = node2.getEastNorth().add(this.xoff, this.yoff);
            Node node3 = new Node(Main.proj.eastNorth2latlon(eastNorth));
            EastNorth eastNorth2 = node.getEastNorth().add(this.xoff, this.yoff);
            Node node4 = new Node(Main.proj.eastNorth2latlon(eastNorth2));
            Way way = new Way(this.selectedSegment.way);
            way.addNode(this.selectedSegment.lowerIndex + 1, node3);
            way.addNode(this.selectedSegment.lowerIndex + 1, node4);
            if (way.nodes.size() == 4) {
                way.addNode(node);
            }
            LinkedList<Command> linkedList = new LinkedList<Command>();
            linkedList.add(new AddCommand(node4));
            linkedList.add(new AddCommand(node3));
            linkedList.add(new ChangeCommand(this.selectedSegment.way, way));
            SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr("Extrude Way"), linkedList);
            Main.main.undoRedo.add(sequenceCommand);
        }
        Main.map.mapView.removeTemporaryLayer(this);
        this.selectedSegment = null;
        this.mode = null;
        this.updateStatusLine();
        Main.map.mapView.repaint();
    }

    public String getModeHelpText() {
        if (this.mode == Mode.select) {
            return I18n.tr("Release the mouse button to select the objects in the rectangle.");
        }
        if (this.mode == Mode.EXTRUDE) {
            return I18n.tr("Draw a rectangle of the desired size, then release the mouse button.");
        }
        if (this.mode == Mode.rotate) {
            return I18n.tr("Release the mouse button to stop rotating.");
        }
        return I18n.tr("Drag a way segment to make a rectangle.");
    }

    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        EXTRUDE,
        rotate,
        select;

    }
}

