/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadGpsTask
implements DownloadDialog.DownloadTask {
    private Future<Task> task = null;
    private JCheckBox checkBox = new JCheckBox(I18n.tr("Raw GPS data"));

    public void download(DownloadAction downloadAction, double d, double d2, double d3, double d4) {
        this.download(downloadAction, d, d2, d3, d4, false, "");
    }

    public void download(DownloadAction downloadAction, double d, double d2, double d3, double d4, boolean bl, String string) {
        Task task = new Task(downloadAction.dialog.newLayer.isSelected(), new BoundingBoxDownloader(d, d2, d3, d4), bl, string);
        this.task = Main.worker.submit(task, task);
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public String getPreferencesSuffix() {
        return "gps";
    }

    public void loadUrl(boolean bl, String string) {
    }

    public String getErrorMessage() {
        if (this.task == null) {
            return "";
        }
        try {
            Task task = this.task.get();
            return task.errorMessage == null ? "" : task.errorMessage;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static class Task
    extends PleaseWaitRunnable {
        private BoundingBoxDownloader reader;
        private GpxData rawData;
        private final boolean newLayer;
        private String msg = "";

        public Task(boolean bl, BoundingBoxDownloader boundingBoxDownloader, boolean bl2, String string) {
            super(I18n.tr("Downloading GPS data"));
            this.msg = string;
            this.reader = boundingBoxDownloader;
            this.newLayer = bl;
            this.silent = bl2;
        }

        public void realRun() throws IOException, SAXException {
            Main.pleaseWaitDlg.setCustomText(this.msg);
            this.rawData = this.reader.parseRawGps();
        }

        protected void finish() {
            if (this.rawData == null) {
                return;
            }
            this.rawData.recalculateBounds();
            String string = I18n.tr("Downloaded GPX Data");
            GpxLayer gpxLayer = new GpxLayer(this.rawData, string);
            Layer layer = this.findMergeLayer();
            if (this.newLayer || layer == null) {
                Main.main.addLayer(gpxLayer);
            } else {
                layer.mergeFrom(gpxLayer);
            }
            Main.pleaseWaitDlg.setCustomText("");
        }

        private Layer findMergeLayer() {
            boolean bl = Main.pref.getBoolean("download.gps.mergeWithLocal", false);
            if (Main.map == null) {
                return null;
            }
            Layer layer = Main.map.mapView.getActiveLayer();
            if (layer != null && layer instanceof GpxLayer && (bl || ((GpxLayer)layer).data.fromServer)) {
                return layer;
            }
            for (Layer layer2 : Main.map.mapView.getAllLayers()) {
                if (!(layer2 instanceof GpxLayer) || !bl && !((GpxLayer)layer2).data.fromServer) continue;
                return layer2;
            }
            return null;
        }

        protected void cancel() {
            if (this.reader != null) {
                this.reader.cancel();
            }
            Main.pleaseWaitDlg.cancel.setEnabled(false);
        }
    }
}

