/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class JosmAction
extends AbstractAction
implements Destroyable {
    protected Shortcut sc;

    public Shortcut getShortcut() {
        if (this.sc == null) {
            this.sc = Shortcut.registerShortcut("core:none", I18n.tr("No Shortcut"), 0, 0);
        }
        return this.sc;
    }

    public JosmAction(String string, String string2, String string3, Shortcut shortcut, boolean bl) {
        super(string, string2 == null ? null : ImageProvider.get(string2));
        this.setHelpId();
        this.sc = shortcut;
        if (this.sc != null) {
            Main.contentPane.getInputMap(2).put(this.sc.getKeyStroke(), string);
            Main.contentPane.getActionMap().put(string, this);
        }
        this.putValue("ShortDescription", Main.platform.makeTooltip(string3, this.sc));
        this.putValue("toolbar", string2);
        if (bl) {
            Main.toolbar.register(this);
        }
    }

    public void destroy() {
        if (this.sc != null) {
            Main.contentPane.getInputMap(2).remove(this.sc.getKeyStroke());
            Main.contentPane.getActionMap().remove(this.sc.getKeyStroke());
        }
    }

    public JosmAction() {
        this.setHelpId();
    }

    public void pasteBufferChanged(DataSet dataSet) {
    }

    public void addListener(JosmAction josmAction) {
    }

    private void setHelpId() {
        String string = "Action/" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        if (string.endsWith("Action")) {
            string = string.substring(0, string.length() - 6);
        }
        this.putValue("help", string);
    }
}

