/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class AlignInCircleAction
extends JosmAction {
    public AlignInCircleAction() {
        super(I18n.tr("Align Nodes in Circle"), "aligncircle", I18n.tr("Move the selected nodes into a circle."), Shortcut.registerShortcut("tools:aligncircle", I18n.tr("Tool: {0}", I18n.tr("Align Nodes in Circle")), 79, 3), true);
    }

    public double determinant(double[][] dArray) {
        double d = 0.0;
        if (dArray.length == 1) {
            d = dArray[0][0];
            return d;
        }
        if (dArray.length == 2) {
            d = dArray[0][0] * dArray[1][1] - dArray[0][1] * dArray[1][0];
            return d;
        }
        for (int i = 0; i < dArray[0].length; ++i) {
            double[][] dArray2 = new double[dArray.length - 1][dArray[0].length - 1];
            for (int j = 1; j < dArray.length; ++j) {
                for (int k = 0; k < dArray[0].length; ++k) {
                    if (k < i) {
                        dArray2[j - 1][k] = dArray[j][k];
                        continue;
                    }
                    if (k <= i) continue;
                    dArray2[j - 1][k - 1] = dArray[j][k];
                }
            }
            d += dArray[0][i] * Math.pow(-1.0, i) * this.determinant(dArray2);
        }
        return d;
    }

    public double distance(EastNorth eastNorth, EastNorth eastNorth2) {
        double d = eastNorth.east() - eastNorth2.east();
        double d2 = eastNorth.north() - eastNorth2.north();
        return Math.sqrt(d * d + d2 * d2);
    }

    public EastNorth circumcenter(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3) {
        double d = eastNorth.east() - eastNorth.east();
        double d2 = eastNorth.north() - eastNorth.north();
        double d3 = eastNorth2.east() - eastNorth.east();
        double d4 = eastNorth2.north() - eastNorth.north();
        double d5 = eastNorth3.east() - eastNorth.east();
        double d6 = eastNorth3.north() - eastNorth.north();
        double[][] dArrayArray = new double[][]{{d, d2, 1.0}, {d3, d4, 1.0}, {d5, d6, 1.0}};
        double[][] dArrayArray2 = new double[][]{{d * d + d2 * d2, d2, 1.0}, {d3 * d3 + d4 * d4, d4, 1.0}, {d5 * d5 + d6 * d6, d6, 1.0}};
        double[][] dArrayArray3 = new double[][]{{d * d + d2 * d2, d, 1.0}, {d3 * d3 + d4 * d4, d3, 1.0}, {d5 * d5 + d6 * d6, d5, 1.0}};
        double d7 = this.determinant(dArrayArray);
        double d8 = this.determinant(dArrayArray2);
        double d9 = this.determinant(dArrayArray3);
        EastNorth eastNorth4 = new EastNorth(d8 / (2.0 * d7) + eastNorth.east(), -d9 / (2.0 * d7) + eastNorth.north());
        Node node = new Node(Main.proj.eastNorth2latlon(eastNorth4));
        if (node.getCoor().isOutSideWorld()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some of the nodes are (almost) in the line"));
            return null;
        }
        return eastNorth4;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object iterator;
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        LinkedList<Way> linkedList2 = new LinkedList<Way>();
        EastNorth eastNorth = null;
        double d = 0.0;
        boolean bl = false;
        for (OsmPrimitive object2 : collection) {
            if (object2 instanceof Node) {
                linkedList.add((Node)object2);
                continue;
            }
            if (!(object2 instanceof Way)) continue;
            linkedList2.add((Way)object2);
        }
        if (linkedList.size() <= 2 && linkedList2.size() == 1) {
            iterator = (Way)linkedList2.toArray()[0];
            if (linkedList.size() > 0) {
                if (linkedList.size() == 1 && ((Way)iterator).nodes.contains(linkedList.toArray()[0])) {
                    bl = true;
                } else {
                    eastNorth = ((Node)linkedList.toArray()[((Way)iterator).nodes.contains(linkedList.toArray()[0]) ? 1 : 0]).getEastNorth();
                    if (linkedList.size() == 2) {
                        d = this.distance(((Node)linkedList.toArray()[0]).getEastNorth(), ((Node)linkedList.toArray()[1]).getEastNorth());
                    }
                }
                linkedList = new LinkedList();
            }
            for (Node node : ((Way)iterator).nodes) {
                if (linkedList.contains(node)) continue;
                linkedList.add(node);
            }
        }
        if (linkedList.size() < 4) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least four nodes."));
            return;
        }
        if (eastNorth == null) {
            eastNorth = new EastNorth(0.0, 0.0);
            iterator = (Node)linkedList.toArray()[linkedList.size() - 1];
            Node node = (Node)linkedList.toArray()[linkedList.size() - 2];
            for (Node node2 : linkedList) {
                void var10_13;
                void var11_23 = var10_13;
                Object object = iterator;
                iterator = node2;
                Object object2 = this.circumcenter(((Node)iterator).getEastNorth(), ((Node)object).getEastNorth(), var11_23.getEastNorth());
                if (object2 == null) {
                    return;
                }
                eastNorth = new EastNorth(eastNorth.east() + ((EastNorth)object2).east(), eastNorth.north() + ((EastNorth)object2).north());
            }
            eastNorth = new EastNorth(eastNorth.east() / (double)linkedList.size(), eastNorth.north() / (double)linkedList.size());
        }
        if (d == 0.0) {
            for (Node node : linkedList) {
                d += this.distance(eastNorth, node.getEastNorth());
            }
            d /= (double)linkedList.size();
        }
        iterator = new LinkedList();
        if (bl) {
            double d2 = Math.PI * 2 / (double)linkedList.size();
            PolarCoor polarCoor = new PolarCoor(((Node)linkedList.toArray()[0]).getEastNorth(), eastNorth, 0.0);
            PolarCoor polarCoor2 = new PolarCoor(((Node)linkedList.toArray()[1]).getEastNorth(), eastNorth, 0.0);
            if (polarCoor.angle > polarCoor2.angle) {
                d2 *= -1.0;
            }
            polarCoor.radius = d;
            for (Object object2 : linkedList) {
                EastNorth eastNorth2 = polarCoor.toEastNorth();
                iterator.add(new MoveCommand((OsmPrimitive)object2, eastNorth2.east() - ((Node)object2).getEastNorth().east(), eastNorth2.north() - ((Node)object2).getEastNorth().north()));
                polarCoor.angle += d2;
            }
        } else {
            for (Object object : linkedList) {
                PolarCoor polarCoor = new PolarCoor(((Node)object).getEastNorth(), eastNorth, 0.0);
                polarCoor.radius = d;
                EastNorth eastNorth3 = polarCoor.toEastNorth();
                iterator.add(new MoveCommand((OsmPrimitive)object, eastNorth3.east() - ((Node)object).getEastNorth().east(), eastNorth3.north() - ((Node)object).getEastNorth().north()));
            }
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Align Nodes in Circle"), (Collection<Command>)iterator));
        Main.map.repaint();
    }

    public class PolarCoor {
        double radius;
        double angle;
        EastNorth origin = new EastNorth(0.0, 0.0);
        double azimuth = 0.0;

        PolarCoor(double d, double d2) {
            this(d, d2, new EastNorth(0.0, 0.0), 0.0);
        }

        PolarCoor(double d, double d2, EastNorth eastNorth, double d3) {
            this.radius = d;
            this.angle = d2;
            this.origin = eastNorth;
            this.azimuth = d3;
        }

        PolarCoor(EastNorth eastNorth) {
            this(eastNorth, new EastNorth(0.0, 0.0), 0.0);
        }

        PolarCoor(EastNorth eastNorth, EastNorth eastNorth2, double d) {
            this.radius = AlignInCircleAction.this.distance(eastNorth, eastNorth2);
            this.angle = Math.atan2(eastNorth.north() - eastNorth2.north(), eastNorth.east() - eastNorth2.east());
            this.origin = eastNorth2;
            this.azimuth = d;
        }

        public EastNorth toEastNorth() {
            return new EastNorth(this.radius * Math.cos(this.angle - this.azimuth) + this.origin.east(), this.radius * Math.sin(this.angle - this.azimuth) + this.origin.north());
        }
    }
}

