/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.GettingStarted;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.PleaseWaitDialog;
import org.openstreetmap.josm.gui.SplashScreen;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Main {
    public static Component parent;
    public static Main main;
    public static final ExecutorService worker;
    public static Preferences pref;
    public static DataSet ds;
    public static DataSet pasteBuffer;
    public static Layer pasteSource;
    public static Projection proj;
    public static MapFrame map;
    public static PleaseWaitDialog pleaseWaitDlg;
    public static boolean applet;
    public static ToolbarPreferences toolbar;
    public UndoRedoHandler undoRedo = new UndoRedoHandler();
    public final MainMenu menu;
    private GettingStarted gettingStarted = new GettingStarted();
    public static int debug_level;
    public static PlatformHook platform;
    public static final JPanel contentPane;
    public static JPanel panel;
    protected static Rectangle bounds;
    private final OsmDataLayer.CommandQueueListener redoUndoListener = new OsmDataLayer.CommandQueueListener(){

        public void commandChanged(int n, int n2) {
            Main.this.menu.undo.setEnabled(n > 0);
            Main.this.menu.redo.setEnabled(n2 > 0);
        }
    };

    public static final void debug(String string) {
        if (debug_level <= 0) {
            return;
        }
        System.out.println(string);
    }

    public final void setMapFrame(MapFrame mapFrame) {
        MapFrame mapFrame2 = map;
        map = mapFrame;
        panel.setVisible(false);
        panel.removeAll();
        if (mapFrame != null) {
            mapFrame.fillPanel(panel);
        } else {
            mapFrame2.destroy();
            panel.add((Component)this.gettingStarted, "Center");
        }
        panel.setVisible(true);
        this.redoUndoListener.commandChanged(0, 0);
        PluginHandler.setMapFrame(mapFrame2, mapFrame);
    }

    public final void removeLayer(Layer layer) {
        if (map != null) {
            Main.map.mapView.removeLayer(layer);
            if (layer instanceof OsmDataLayer) {
                ds = new DataSet();
            }
            if (Main.map.mapView.getAllLayers().isEmpty()) {
                this.setMapFrame(null);
            }
        }
    }

    public Main() {
        this(null);
    }

    public Main(SplashScreen splashScreen) {
        main = this;
        platform.startupHook();
        contentPane.add((Component)panel, "Center");
        panel.add((Component)this.gettingStarted, "Center");
        if (splashScreen != null) {
            splashScreen.setStatus(I18n.tr("Creating main GUI"));
        }
        this.menu = new MainMenu();
        this.undoRedo.listenerCommands.add(this.redoUndoListener);
        contentPane.add((Component)Main.toolbar.control, "North");
        contentPane.getInputMap(2).put(Shortcut.registerShortcut("system:help", I18n.tr("Help"), 112, 5).getKeyStroke(), "Help");
        contentPane.getActionMap().put("Help", this.menu.help);
        TaggingPresetPreference.initialize();
        MapPaintPreference.initialize();
        toolbar.refreshToolbarControl();
        Main.toolbar.control.updateUI();
        contentPane.updateUI();
    }

    public final void addLayer(Layer layer) {
        if (map == null) {
            MapFrame mapFrame = new MapFrame();
            this.setMapFrame(mapFrame);
            mapFrame.selectMapMode((MapMode)mapFrame.getDefaultButtonAction());
            mapFrame.setVisible(true);
            mapFrame.setVisibleDialogs();
        }
        Main.map.mapView.addLayer(layer);
    }

    public final OsmDataLayer editLayer() {
        if (map == null || Main.map.mapView.editLayer == null) {
            this.menu.newAction.actionPerformed(null);
        }
        return Main.map.mapView.editLayer;
    }

    public static void preConstructorInit(Map<String, Collection<String>> map) {
        Object object;
        try {
            proj = (Projection)Class.forName(pref.get("projection")).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(null, I18n.tr("The projection could not be read from preferences. Using Mercartor"));
            proj = new Mercator();
        }
        try {
            try {
                object = pref.get("laf");
                if (object != null && ((String)object).length() > 0) {
                    UIManager.setLookAndFeel((String)object);
                }
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                System.out.println("Look and Feel not supported: " + pref.get("laf"));
            }
            toolbar = new ToolbarPreferences();
            contentPane.updateUI();
            panel.updateUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UIManager.put("OptionPane.okIcon", ImageProvider.get("ok"));
        UIManager.put("OptionPane.yesIcon", UIManager.get("OptionPane.okIcon"));
        UIManager.put("OptionPane.cancelIcon", ImageProvider.get("cancel"));
        UIManager.put("OptionPane.noIcon", UIManager.get("OptionPane.cancelIcon"));
        object = Toolkit.getDefaultToolkit().getScreenSize();
        String string = pref.get("gui.geometry");
        if (map.containsKey("geometry")) {
            string = map.get("geometry").iterator().next();
        }
        if (string.length() != 0) {
            Matcher matcher = Pattern.compile("(\\d+)x(\\d+)(([+-])(\\d+)([+-])(\\d+))?").matcher(string);
            if (matcher.matches()) {
                int n = Integer.valueOf(matcher.group(1));
                int n2 = Integer.valueOf(matcher.group(2));
                int n3 = 0;
                int n4 = 0;
                if (matcher.group(3) != null) {
                    n3 = Integer.valueOf(matcher.group(5));
                    n4 = Integer.valueOf(matcher.group(7));
                    if (matcher.group(4).equals("-")) {
                        n3 = ((Dimension)object).width - n3 - n;
                    }
                    if (matcher.group(6).equals("-")) {
                        n4 = ((Dimension)object).height - n4 - n2;
                    }
                }
                bounds = new Rectangle(n3, n4, n, n2);
                if (!pref.get("gui.geometry").equals(string)) {
                    pref.put("gui.geometry", string);
                }
            } else {
                System.out.println("Ignoring malformed geometry: " + string);
            }
        }
        if (bounds == null) {
            bounds = !map.containsKey("no-maximize") ? new Rectangle(0, 0, ((Dimension)object).width, ((Dimension)object).height) : new Rectangle(1000, 740);
        }
        pleaseWaitDlg = new PleaseWaitDialog(null);
    }

    public void postConstructorProcessCmdLine(Map<String, Collection<String>> map) {
        pleaseWaitDlg = new PleaseWaitDialog(parent);
        if (map.containsKey("download")) {
            for (String string : map.get("download")) {
                Main.downloadFromParamString(false, string);
            }
        }
        if (map.containsKey("downloadgps")) {
            for (String string : map.get("downloadgps")) {
                Main.downloadFromParamString(true, string);
            }
        }
        if (map.containsKey("selection")) {
            for (String string : map.get("selection")) {
                SearchAction.search(string, SearchAction.SearchMode.add, false, false);
            }
        }
    }

    public static boolean breakBecauseUnsavedChanges() {
        Shortcut.savePrefs();
        if (map != null) {
            boolean bl = false;
            boolean bl2 = false;
            for (Layer layer : Main.map.mapView.getAllLayers()) {
                if (!(layer instanceof OsmDataLayer) || !((OsmDataLayer)layer).isModified()) continue;
                bl = true;
                bl2 = ((OsmDataLayer)layer).uploadedModified;
                break;
            }
            if (bl) {
                String string = bl2 ? "\n" + I18n.tr("Hint: Some changes came from uploading new data to the server.") : "";
                int n = new ExtendedDialog(parent, I18n.tr("Unsaved Changes"), new JLabel(I18n.tr("There are unsaved changes. Discard the changes and continue?") + (String)string), new String[]{I18n.tr("Save and Exit"), I18n.tr("Discard and Exit"), I18n.tr("Cancel")}, new String[]{"save.png", "exit.png", "cancel.png"}).getValue();
                if (n == 1) {
                    Boolean bl3 = false;
                    for (Layer layer : Main.map.mapView.getAllLayers()) {
                        SaveAction saveAction;
                        if (!(layer instanceof OsmDataLayer) || !((OsmDataLayer)layer).isModified() || (saveAction = new SaveAction(layer)).doSave().booleanValue()) continue;
                        bl3 = true;
                    }
                    return bl3;
                }
                if (n != 2) {
                    return true;
                }
            }
        }
        return false;
    }

    private static void downloadFromParamString(boolean bl, String string) {
        if (string.startsWith("http:")) {
            Bounds bounds = OsmUrlToBounds.parse(string);
            if (bounds == null) {
                JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed URL: \"{0}\"", string));
            } else {
                DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
                downloadOsmTask.download(Main.main.menu.download, bounds.min.lat(), bounds.min.lon(), bounds.max.lat(), bounds.max.lon());
            }
            return;
        }
        if (string.startsWith("file:")) {
            try {
                Main.main.menu.openFile.openFile(new File(new URI(string)));
            }
            catch (URISyntaxException uRISyntaxException) {
                JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed file URL: \"{0}\"", string));
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == 4) {
            try {
                DownloadDialog.DownloadTask downloadTask = bl ? new DownloadGpsTask() : new DownloadOsmTask();
                downloadTask.download(Main.main.menu.download, Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken()));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Main.main.menu.openFile.openFile(new File(string));
    }

    protected static void determinePlatformHook() {
        String string = System.getProperty("os.name");
        if (string == null) {
            System.err.println("Your operating system has no name, so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        } else if (string.toLowerCase().startsWith("windows")) {
            platform = new PlatformHookWindows();
        } else if (string.equals("Linux") || string.equals("Solaris") || string.equals("SunOS") || string.equals("AIX") || string.equals("FreeBSD") || string.equals("NetBSD") || string.equals("OpenBSD")) {
            platform = new PlatformHookUnixoid();
        } else if (string.toLowerCase().startsWith("mac os x")) {
            platform = new PlatformHookOsx();
        } else {
            System.err.println("I don't know your operating system '" + string + "', so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        }
    }

    public static String getLanguageCodeU() {
        String string = Main.getLanguageCode();
        if (string.equals("en")) {
            return "";
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1) + ":";
    }

    public static String getLanguageCode() {
        String string = Locale.getDefault().toString();
        if (string.equals("iw_IL")) {
            return "he";
        }
        if (string.equals("en_GB")) {
            return string;
        }
        return Locale.getDefault().getLanguage();
    }

    public static void saveGuiGeometry() {
        String string = "";
        try {
            if (((JFrame)parent).getExtendedState() == 0) {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                Rectangle rectangle = parent.getBounds();
                int n = (int)rectangle.getWidth();
                int n2 = (int)rectangle.getHeight();
                int n3 = (int)rectangle.getX();
                int n4 = (int)rectangle.getY();
                if (n > dimension.width) {
                    n = dimension.width;
                }
                if (n2 > dimension.height) {
                    n = dimension.height;
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                string = n + "x" + n2 + "+" + n3 + "+" + n4;
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to save GUI geometry: " + exception);
        }
        pref.put("gui.geometry", string);
    }

    static {
        worker = Executors.newSingleThreadExecutor();
        pref = new Preferences();
        ds = new DataSet();
        pasteBuffer = new DataSet();
        applet = false;
        debug_level = 1;
        contentPane = new JPanel(new BorderLayout());
        panel = new JPanel(new BorderLayout());
    }
}

