/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferCancelledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmServerWriter {
    public Collection<OsmPrimitive> processed;
    private OsmApi api = new OsmApi();
    private static final int MSECS_PER_SECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MSECS_PER_MINUTE = 60000;
    long uploadStartTime;

    public String timeLeft(int n, int n2) {
        long l = System.currentTimeMillis();
        long l2 = l - this.uploadStartTime;
        if (l2 == 0L) {
            l2 = 1L;
        }
        float f = (float)n / (float)l2;
        float f2 = n2 - n;
        int n3 = (int)(f2 / f);
        int n4 = n3 / 60000;
        int n5 = n3 / 1000 % 60;
        String string = Integer.toString(n4) + ":";
        if (n5 < 10) {
            string = string + "0";
        }
        string = string + Integer.toString(n5);
        return string;
    }

    public void uploadOsm(String string, Collection<OsmPrimitive> collection) {
        Object object;
        this.processed = new LinkedList<OsmPrimitive>();
        try {
            this.api.initialize();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, I18n.tr("Failed to initialize communication with the OSM server {0}.\nCheck the server URL in your preferences and your internet connection.", Main.pref.get("osm-server.url")), I18n.tr("Error"), 0);
            exception.printStackTrace();
            return;
        }
        Main.pleaseWaitDlg.progress.setMaximum(collection.size());
        Main.pleaseWaitDlg.progress.setValue(0);
        boolean bl = this.api.hasChangesetSupport();
        boolean bl2 = Main.pref.getBoolean("osm-server.atomic-upload", "0.6".equals(this.api.getVersion()));
        try {
            if (bl) {
                object = "";
                LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection("upload.comment.history", new LinkedList<String>()));
                if (linkedList.size() > 0) {
                    object = (String)linkedList.get(0);
                }
                this.api.createChangeset((String)object);
            }
        }
        catch (OsmTransferException osmTransferException) {
            this.dealWithTransferException(osmTransferException);
            return;
        }
        try {
            if (bl2) {
                this.processed.addAll(this.api.uploadDiff(collection));
            } else {
                object = new NameVisitor();
                this.uploadStartTime = System.currentTimeMillis();
                for (OsmPrimitive osmPrimitive : collection) {
                    osmPrimitive.visit((Visitor)object);
                    int n = Main.pleaseWaitDlg.progress.getValue();
                    String string2 = this.timeLeft(n, collection.size());
                    Main.pleaseWaitDlg.currentAction.setText(I18n.tr("{0}% ({1}/{2}), {3} left. Uploading {4}: {5} (id: {6})", Math.round(100.0 * (double)n / (double)collection.size()), n, collection.size(), string2, I18n.tr(((NameVisitor)object).className), ((NameVisitor)object).name, osmPrimitive.id));
                    this.makeApiRequest(osmPrimitive);
                    this.processed.add(osmPrimitive);
                    Main.pleaseWaitDlg.progress.setValue(n + 1);
                }
            }
            if (bl) {
                this.api.stopChangeset();
            }
        }
        catch (OsmTransferException osmTransferException) {
            try {
                if (bl) {
                    this.api.stopChangeset();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dealWithTransferException(osmTransferException);
        }
    }

    void makeApiRequest(OsmPrimitive osmPrimitive) throws OsmTransferException {
        if (osmPrimitive.deleted) {
            this.api.deletePrimitive(osmPrimitive);
        } else if (osmPrimitive.id == 0L) {
            this.api.createPrimitive(osmPrimitive);
        } else {
            this.api.modifyPrimitive(osmPrimitive);
        }
    }

    private void dealWithTransferException(OsmTransferException osmTransferException) {
        if (osmTransferException instanceof OsmTransferCancelledException) {
            return;
        }
        JOptionPane.showMessageDialog(Main.parent, osmTransferException.getMessage());
    }
}

