/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class OsmServerLocationReader
extends OsmServerReader {
    String url;

    public OsmServerLocationReader(String string) {
        this.url = string;
    }

    public DataSet parseOsm() throws SAXException, IOException {
        try {
            Main.pleaseWaitDlg.progress.setValue(0);
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Contacting Server..."));
            InputStream inputStream = this.getInputStreamRaw(this.url, Main.pleaseWaitDlg);
            if (inputStream == null) {
                return null;
            }
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Downloading OSM data..."));
            DataSet dataSet = OsmReader.parseDataSet(inputStream, null, Main.pleaseWaitDlg);
            inputStream.close();
            this.activeConnection = null;
            return dataSet;
        }
        catch (IOException iOException) {
            if (this.cancel) {
                return null;
            }
            throw iOException;
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                return null;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }
}

