/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.FutureTask;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.CreateOsmChangeVisitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.DiffResultReader;
import org.openstreetmap.josm.io.MyHttpHandler;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferCancelledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmApi
extends OsmConnection {
    private Changeset changeset;
    private String version = null;
    private String minVersion = null;
    private String maxVersion = null;
    private String maxArea = null;
    private boolean initialized = false;
    private StringWriter swriter = new StringWriter();
    private OsmWriter osmWriter = new OsmWriter(new PrintWriter(this.swriter), true, null);

    public static String which(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            return "node";
        }
        if (osmPrimitive instanceof Way) {
            return "way";
        }
        if (osmPrimitive instanceof Relation) {
            return "relation";
        }
        if (osmPrimitive instanceof Changeset) {
            return "changeset";
        }
        return "";
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasChangesetSupport() {
        return this.version != null && this.version.compareTo("0.6") >= 0;
    }

    public void initialize() throws UnknownHostException, SocketTimeoutException, ConnectException, Exception {
        this.initAuthentication();
        try {
            this.initialized = true;
            String string = this.sendRequest("GET", "capabilities", null);
            InputSource inputSource = new InputSource(new StringReader(string));
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)new CapabilitiesParser());
            if (this.maxVersion.compareTo("0.6") >= 0) {
                this.version = "0.6";
            } else if (this.minVersion.compareTo("0.5") <= 0) {
                this.version = "0.5";
            } else {
                System.err.println(I18n.tr("This version of JOSM is incompatible with the configured server."));
                System.err.println(I18n.tr("It supports protocol versions 0.5 and 0.6, while the server says it supports {0} to {1}.", this.minVersion, this.maxVersion));
                this.initialized = false;
            }
            System.out.println(I18n.tr("Communications with {0} established using protocol version {1}", Main.pref.get("osm-server.url"), this.version));
            this.osmWriter.setVersion(this.version);
        }
        catch (Exception exception) {
            this.initialized = false;
            throw exception;
        }
    }

    private String toXml(OsmPrimitive osmPrimitive, boolean bl) {
        this.swriter.getBuffer().setLength(0);
        this.osmWriter.setWithBody(bl);
        this.osmWriter.setChangeset(this.changeset);
        this.osmWriter.header();
        osmPrimitive.visit(this.osmWriter);
        this.osmWriter.footer();
        this.osmWriter.out.flush();
        return this.swriter.toString();
    }

    public static int parseInt(String string) throws OsmTransferException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            return Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            throw new OsmTransferException(I18n.tr("Cannot read numeric value from response"));
        }
    }

    public static long parseLong(String string) throws OsmTransferException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            return Long.parseLong(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            throw new OsmTransferException(I18n.tr("Cannot read numeric value from response"));
        }
    }

    public String getBaseUrl() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(Main.pref.get("osm-server.url"));
        if (this.version != null) {
            stringBuffer.append("/");
            stringBuffer.append(this.version);
        }
        stringBuffer.append("/");
        while ((n = stringBuffer.indexOf("//", 6)) > -1) {
            stringBuffer.delete(n, n + 1);
        }
        return stringBuffer.toString();
    }

    public void createPrimitive(OsmPrimitive osmPrimitive) throws OsmTransferException {
        osmPrimitive.id = OsmApi.parseLong(this.sendRequest("PUT", OsmApi.which(osmPrimitive) + "/create", this.toXml(osmPrimitive, true)));
        osmPrimitive.version = 1;
    }

    public void modifyPrimitive(OsmPrimitive osmPrimitive) throws OsmTransferException {
        if (this.version.equals("0.5")) {
            this.sendRequest("PUT", OsmApi.which(osmPrimitive) + "/" + osmPrimitive.id, this.toXml(osmPrimitive, true));
        } else {
            osmPrimitive.version = OsmApi.parseInt(this.sendRequest("PUT", OsmApi.which(osmPrimitive) + "/" + osmPrimitive.id, this.toXml(osmPrimitive, true)));
        }
    }

    public void deletePrimitive(OsmPrimitive osmPrimitive) throws OsmTransferException {
        this.sendRequest("DELETE", OsmApi.which(osmPrimitive) + "/" + osmPrimitive.id, this.version.equals("0.5") ? null : this.toXml(osmPrimitive, false));
    }

    public void createChangeset(String string) throws OsmTransferException {
        this.changeset = new Changeset();
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Opening changeset..."));
        Properties properties = System.getProperties();
        Object object = properties.get("http.agent");
        this.changeset.put("created_by", object == null ? "JOSM" : object.toString());
        this.changeset.put("comment", string);
        this.createPrimitive(this.changeset);
    }

    public void stopChangeset() throws OsmTransferException {
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Closing changeset..."));
        this.sendRequest("PUT", "changeset/" + this.changeset.id + "/close", null);
        this.changeset = null;
    }

    public Collection<OsmPrimitive> uploadDiff(final Collection<OsmPrimitive> collection) throws OsmTransferException {
        OsmTransferException osmTransferException;
        if (this.changeset == null) {
            throw new OsmTransferException(I18n.tr("No changeset present for diff upload"));
        }
        final ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UploadDiffTask
        extends PleaseWaitRunnable {
            private boolean uploadCancelled;
            private boolean uploadFailed;
            private Throwable lastThrowable;

            public UploadDiffTask(String string) {
                super(string, false);
                this.uploadCancelled = false;
                this.uploadFailed = false;
                this.lastThrowable = null;
            }

            @Override
            protected void realRun() throws SAXException, IOException {
                CreateOsmChangeVisitor createOsmChangeVisitor = new CreateOsmChangeVisitor(OsmApi.this.changeset, OsmApi.this);
                for (Object object : collection) {
                    int n = Main.pleaseWaitDlg.progress.getValue();
                    Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Preparing..."));
                    ((OsmPrimitive)object).visit(createOsmChangeVisitor);
                    Main.pleaseWaitDlg.progress.setValue(n + 1);
                }
                Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Uploading..."));
                String string = createOsmChangeVisitor.getDocument();
                try {
                    Object object;
                    object = OsmApi.this.sendRequest("POST", "changeset/" + ((OsmApi)OsmApi.this).changeset.id + "/upload", string);
                    DiffResultReader.parseDiffResult((String)object, collection, arrayList, createOsmChangeVisitor.getNewIdMap(), Main.pleaseWaitDlg);
                }
                catch (Exception exception) {
                    if (this.isUploadCancelled()) {
                        System.out.println("Ignoring exception caught because upload is cancelled. Exception is: " + exception.toString());
                        return;
                    }
                    this.uploadFailed = true;
                    this.lastThrowable = exception;
                }
            }

            @Override
            protected void finish() {
            }

            @Override
            protected void cancel() {
                OsmApi.this.activeConnection.disconnect();
                this.uploadCancelled = true;
            }

            public boolean isUploadCancelled() {
                return this.uploadCancelled;
            }

            public boolean isUploadFailed() {
                return this.uploadFailed;
            }

            public Throwable getLastThrowable() {
                return this.lastThrowable;
            }
        }
        UploadDiffTask uploadDiffTask = new UploadDiffTask(I18n.tr("Uploading data"));
        try {
            osmTransferException = null;
            FutureTask<Object> futureTask = new FutureTask<Object>(uploadDiffTask, osmTransferException);
            futureTask.run();
            futureTask.get();
        }
        catch (Throwable throwable) {
            if (uploadDiffTask.isUploadCancelled()) {
                throw new OsmTransferCancelledException();
            }
            throw new OsmTransferException(throwable);
        }
        if (uploadDiffTask.isUploadFailed()) {
            if (uploadDiffTask.getLastThrowable() != null && uploadDiffTask.getLastThrowable() instanceof OsmTransferException) {
                osmTransferException = (OsmTransferException)uploadDiffTask.getLastThrowable();
                throw osmTransferException;
            }
            throw new OsmTransferException(I18n.tr("Data upload failed for unknown reason"));
        }
        if (uploadDiffTask.isUploadCancelled()) {
            throw new OsmTransferCancelledException();
        }
        return arrayList;
    }

    private void sleepAndListen() throws OsmTransferCancelledException {
        for (int i = 0; i < 10; ++i) {
            if (this.cancel || this.isAuthCancelled()) {
                throw new OsmTransferCancelledException();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private String sendRequest(String string, String string2, String string3) throws OsmTransferException {
        if (!this.initialized) {
            throw new OsmTransferException(I18n.tr("Not initialized"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 5;
        while (true) {
            try {
                String string4;
                void var9_18;
                int n2;
                while (true) {
                    URL uRL = new URL(new URL(this.getBaseUrl()), string2, new MyHttpHandler());
                    System.out.print(string + " " + uRL + "... ");
                    this.activeConnection = (HttpURLConnection)uRL.openConnection();
                    this.activeConnection.setConnectTimeout(15000);
                    this.activeConnection.setRequestMethod(string);
                    this.addAuth(this.activeConnection);
                    if (string.equals("PUT") || string.equals("POST")) {
                        this.activeConnection.setDoOutput(true);
                        this.activeConnection.setRequestProperty("Content-type", "text/xml");
                        OutputStream outputStream = this.activeConnection.getOutputStream();
                        if (string3 != null) {
                            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                            bufferedWriter.write(string3);
                            bufferedWriter.flush();
                        }
                        outputStream.close();
                    }
                    this.activeConnection.connect();
                    System.out.println(this.activeConnection.getResponseMessage());
                    n2 = this.activeConnection.getResponseCode();
                    if (n2 < 500 || n-- <= 0) break;
                    this.sleepAndListen();
                }
                stringBuffer.setLength(0);
                Object var9_15 = null;
                try {
                    InputStream inputStream = this.activeConnection.getInputStream();
                }
                catch (IOException iOException) {
                    InputStream inputStream = this.activeConnection.getErrorStream();
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)var9_18));
                while ((string4 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string4);
                    stringBuffer.append("\n");
                }
                stringBuffer2.setLength(0);
                if (this.activeConnection.getHeaderField("Error") != null) {
                    String string5 = this.activeConnection.getHeaderField("Error");
                    System.err.println("Error header: " + string5);
                    stringBuffer2.append(I18n.tr(string5));
                } else if (n2 != 200 && stringBuffer.length() > 0) {
                    System.err.println("Error body: " + stringBuffer);
                    stringBuffer2.append(I18n.tr(stringBuffer.toString()));
                } else {
                    stringBuffer2.append(this.activeConnection.getResponseMessage());
                }
                this.activeConnection.disconnect();
                if (n2 == 200) return stringBuffer.toString();
                throw new OsmTransferException(stringBuffer2.toString());
            }
            catch (UnknownHostException unknownHostException) {
                throw new OsmTransferException(I18n.tr("Unknown host") + ": " + unknownHostException.getMessage(), unknownHostException);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (n-- <= 0) throw new OsmTransferException(socketTimeoutException.getMessage() + " " + socketTimeoutException.getClass().getCanonicalName(), socketTimeoutException);
                continue;
            }
            catch (ConnectException connectException) {
                if (n-- <= 0) throw new OsmTransferException(connectException.getMessage() + " " + connectException.getClass().getCanonicalName(), connectException);
                continue;
            }
            catch (Exception exception) {
                if (!(exception instanceof OsmTransferException)) throw new OsmTransferException(exception);
                throw (OsmTransferException)exception;
            }
            break;
        }
    }

    private class CapabilitiesParser
    extends DefaultHandler {
        private CapabilitiesParser() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("version")) {
                OsmApi.this.minVersion = attributes.getValue("minimum");
                OsmApi.this.maxVersion = attributes.getValue("maximum");
            } else if (string3.equals("area")) {
                OsmApi.this.maxArea = attributes.getValue("maximum");
            }
        }
    }
}

