/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.QuadStateCheckBox;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UrlLabel;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggingPreset
extends AbstractAction {
    public TaggingPresetMenu group = null;
    public String name;
    public String locale_name;
    public static final String DIFFERENT = I18n.tr("<different>");
    public List<String> types;
    public List<Item> data = new LinkedList<Item>();
    private static HashMap<String, String> lastValue = new HashMap();
    private static Collection<String> allowedtypes = Arrays.asList(I18n.marktr("way"), I18n.marktr("node"), I18n.marktr("relation"), I18n.marktr("closedway"));
    private boolean originalSelectionEmpty = false;

    static Usage determineTextUsage(Collection<OsmPrimitive> collection, String string) {
        Usage usage = new Usage();
        usage.values = new HashSet<String>();
        for (OsmPrimitive osmPrimitive : collection) {
            String string2 = osmPrimitive.get(string);
            if (string2 != null) {
                usage.values.add(string2);
            } else {
                usage.hadEmpty = true;
            }
            if (osmPrimitive.keys == null || osmPrimitive.keys.size() <= 0) continue;
            usage.hadKeys = true;
        }
        return usage;
    }

    static Usage determineBooleanUsage(Collection<OsmPrimitive> collection, String string) {
        Usage usage = new Usage();
        usage.values = new HashSet<String>();
        for (OsmPrimitive osmPrimitive : collection) {
            usage.values.add(OsmUtils.getNamedOsmBoolean(osmPrimitive.get(string)));
        }
        return usage;
    }

    public void setDisplayName() {
        this.putValue("Name", this.getName());
        this.putValue("toolbar", "tagging_" + this.getRawName());
        this.putValue("ShortDescription", this.group != null ? I18n.tr("Use preset ''{0}'' of group ''{1}''", this.getLocaleName(), this.group.getName()) : I18n.tr("Use preset ''{0}''", this.getLocaleName()));
    }

    public String getLocaleName() {
        if (this.locale_name == null) {
            this.locale_name = I18n.tr(this.name);
        }
        return this.locale_name;
    }

    public String getName() {
        return this.group != null ? this.group.getName() + "/" + this.getLocaleName() : this.getLocaleName();
    }

    public String getRawName() {
        return this.group != null ? this.group.getRawName() + "/" + this.name : this.name;
    }

    public void setIcon(String string) {
        Collection<String> collection = Main.pref.getCollection("taggingpreset.iconpaths", null);
        ImageIcon imageIcon = ImageProvider.getIfAvailable(collection, "presets", null, string);
        if (imageIcon == null) {
            System.out.println("Could not get presets icon " + string);
            imageIcon = new ImageIcon(string);
        }
        if (Math.max(imageIcon.getIconHeight(), imageIcon.getIconWidth()) != 16) {
            imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(16, 16, 4));
        }
        this.putValue("SmallIcon", imageIcon);
    }

    public void setType(String string) throws SAXException {
        this.types = Arrays.asList(string.split(","));
        for (String string2 : this.types) {
            if (allowedtypes.contains(string2)) continue;
            throw new SAXException(I18n.tr("Unknown type: {0}", string2));
        }
    }

    public static List<TaggingPreset> readAll(Reader reader) throws SAXException {
        XmlObjectParser xmlObjectParser = new XmlObjectParser();
        xmlObjectParser.mapOnStart("item", TaggingPreset.class);
        xmlObjectParser.mapOnStart("separator", TaggingPresetSeparator.class);
        xmlObjectParser.mapBoth("group", TaggingPresetMenu.class);
        xmlObjectParser.map("text", Text.class);
        xmlObjectParser.map("link", Link.class);
        xmlObjectParser.mapOnStart("optional", Optional.class);
        xmlObjectParser.map("check", Check.class);
        xmlObjectParser.map("combo", Combo.class);
        xmlObjectParser.map("label", Label.class);
        xmlObjectParser.map("space", Space.class);
        xmlObjectParser.map("key", Key.class);
        LinkedList<TaggingPreset> linkedList = new LinkedList<TaggingPreset>();
        TaggingPreset taggingPreset = null;
        xmlObjectParser.start(reader);
        while (xmlObjectParser.hasNext()) {
            TaggingPreset taggingPreset2;
            Object object = xmlObjectParser.next();
            if (object instanceof TaggingPresetMenu) {
                taggingPreset2 = (TaggingPresetMenu)object;
                if (taggingPreset2 == taggingPreset) {
                    taggingPreset = ((TaggingPresetMenu)taggingPreset2).group;
                    continue;
                }
                ((TaggingPresetMenu)taggingPreset2).setDisplayName();
                ((TaggingPresetMenu)taggingPreset2).group = taggingPreset;
                taggingPreset = taggingPreset2;
                linkedList.add(taggingPreset2);
                Main.toolbar.register(taggingPreset2);
                continue;
            }
            if (object instanceof TaggingPresetSeparator) {
                taggingPreset2 = (TaggingPresetSeparator)object;
                ((TaggingPresetSeparator)taggingPreset2).group = taggingPreset;
                linkedList.add(taggingPreset2);
                continue;
            }
            if (object instanceof TaggingPreset) {
                taggingPreset2 = (TaggingPreset)object;
                taggingPreset2.group = taggingPreset;
                taggingPreset2.setDisplayName();
                linkedList.add(taggingPreset2);
                Main.toolbar.register(taggingPreset2);
                continue;
            }
            linkedList.getLast().data.add((Item)object);
        }
        return linkedList;
    }

    public static Collection<TaggingPreset> readFromPreferences() {
        LinkedList<TaggingPreset> linkedList = new LinkedList<TaggingPreset>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if (Main.pref.getBoolean("taggingpreset.enable-defaults", true)) {
            linkedList2.add("resource://presets/presets.xml");
        }
        linkedList2.addAll(Main.pref.getCollection("taggingpreset.sources", new LinkedList<String>()));
        for (String string : linkedList2) {
            try {
                InputStreamReader inputStreamReader;
                MirroredInputStream mirroredInputStream = new MirroredInputStream(string);
                try {
                    inputStreamReader = new InputStreamReader((InputStream)mirroredInputStream, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    inputStreamReader = new InputStreamReader(mirroredInputStream);
                }
                linkedList.addAll(TaggingPreset.readAll(new BufferedReader(inputStreamReader)));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read tagging preset source: {0}", string));
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error parsing {0}: ", string) + sAXException.getMessage());
            }
        }
        return linkedList;
    }

    public JPanel createPanel(Collection<OsmPrimitive> collection) {
        if (this.data == null) {
            return null;
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        LinkedList<Item> linkedList = new LinkedList<Item>();
        if (this.types != null) {
            Iterator iterator = new JPanel();
            for (String string : this.types) {
                JLabel jLabel = new JLabel(ImageProvider.get("Mf_" + string));
                jLabel.setToolTipText(I18n.tr("Elements of type {0} are supported.", I18n.tr(string)));
                ((Container)((Object)iterator)).add(jLabel);
            }
            jPanel.add((Component)((Object)iterator), GBC.eol());
        }
        for (Item item : this.data) {
            if (item instanceof Link) {
                linkedList.add(item);
                continue;
            }
            item.addToPanel(jPanel, collection);
        }
        for (Item item : linkedList) {
            item.addToPanel(jPanel, collection);
        }
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Collection<OsmPrimitive> collection = this.createSelection(Main.ds.getSelected());
        JPanel jPanel = this.createPanel(collection);
        if (jPanel == null) {
            return;
        }
        int n = 1;
        if (jPanel.getComponentCount() != 0) {
            object = I18n.trn("Change {0} object", "Change {0} objects", collection.size(), collection.size());
            if (collection.size() == 0) {
                object = this.originalSelectionEmpty ? I18n.tr("Nothing selected!") : I18n.tr("Selection unsuitable!");
            }
            class PresetDialog
            extends ExtendedDialog {
                public PresetDialog(Component component, String string, boolean bl) {
                    super(Main.parent, string, new String[]{I18n.tr("Apply Preset"), I18n.tr("Cancel")}, true);
                    this.contentConstraints = GBC.eol().fill().insets(5, 10, 5, 0);
                    this.setupDialog(component, new String[]{"ok.png", "cancel.png"});
                    ((JButton)this.buttons.get(0)).setEnabled(!bl);
                    ((JButton)this.buttons.get(0)).setToolTipText(string);
                    this.setVisible(true);
                }
            }
            n = new PresetDialog(jPanel, (String)object, collection.size() == 0).getValue();
        }
        if (collection.size() != 0 && n == 1 && (object = this.createCommand(collection)) != null) {
            Main.main.undoRedo.add((Command)object);
        }
        Main.ds.setSelected(Main.ds.getSelected());
    }

    private Collection<OsmPrimitive> createSelection(Collection<OsmPrimitive> collection) {
        this.originalSelectionEmpty = collection.size() == 0;
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (this.types != null && (osmPrimitive instanceof Relation ? !this.types.contains("relation") : (osmPrimitive instanceof Node ? !this.types.contains("node") : osmPrimitive instanceof Way && !this.types.contains("way") && (!this.types.contains("closedway") || !((Way)osmPrimitive).isClosed())))) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    private Command createCommand(Collection<OsmPrimitive> collection) {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (Item item : this.data) {
            item.addCommands(collection, linkedList);
        }
        if (linkedList.size() == 0) {
            return null;
        }
        if (linkedList.size() == 1) {
            return (Command)linkedList.get(0);
        }
        return new SequenceCommand(I18n.tr("Change Properties"), linkedList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Key
    extends Item {
        public String key;
        public String value;

        @Override
        public void addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> collection, List<Command> list) {
            list.add(new ChangePropertyCommand(collection, this.key, this.value != null && !this.value.equals("") ? this.value : null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Space
    extends Item {
        @Override
        public void addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            jPanel.add((Component)new JLabel(" "), GBC.eol());
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> collection, List<Command> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Optional
    extends Item {
        @Override
        public void addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            jPanel.add((Component)new JLabel(" "), GBC.eol());
            jPanel.add((Component)new JLabel(I18n.tr("Optional Attributes:")), GBC.eol());
            jPanel.add((Component)new JLabel(" "), GBC.eol());
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> collection, List<Command> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Link
    extends Item {
        public String href;
        public String text;
        public String locale_text;
        public String locale_href;

        @Override
        public void addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            String string;
            if (this.locale_text == null) {
                String string2 = this.locale_text = this.text == null ? I18n.tr("More information about this feature") : I18n.tr(this.text);
            }
            if ((string = this.locale_href) == null) {
                string = this.href;
            }
            if (string != null) {
                jPanel.add((Component)new UrlLabel(string, this.locale_text), GBC.eol().anchor(17));
            }
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> collection, List<Command> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Label
    extends Item {
        public String text;
        public String locale_text;

        @Override
        public void addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            if (this.locale_text == null) {
                this.locale_text = I18n.tr(this.text);
            }
            jPanel.add((Component)new JLabel(this.locale_text), GBC.eol());
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> collection, List<Command> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Combo
    extends Item {
        public String key;
        public String text;
        public String locale_text;
        public String values;
        public String display_values;
        public String locale_display_values;
        public String default_;
        public boolean delete_if_empty = false;
        public boolean editable = true;
        public boolean use_last_as_default = false;
        private JComboBox combo;
        private LinkedHashMap<String, String> lhm;
        private Usage usage;
        private String originalValue;

        @Override
        public void addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            this.usage = TaggingPreset.determineTextUsage(collection, this.key);
            String[] stringArray = this.values.split(",");
            String[] stringArray2 = this.locale_display_values != null ? this.locale_display_values.split(",") : (this.display_values != null ? this.display_values.split(",") : stringArray);
            this.lhm = new LinkedHashMap();
            if (!this.usage.allSimilar().booleanValue() && !this.usage.unused().booleanValue()) {
                this.lhm.put(DIFFERENT, DIFFERENT);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.lhm.put(stringArray[i], this.locale_display_values == null ? I18n.tr(stringArray2[i]) : stringArray2[i]);
            }
            if (!this.usage.unused().booleanValue()) {
                for (String string : this.usage.values) {
                    if (this.lhm.containsKey(string)) continue;
                    this.lhm.put(string, string);
                }
            }
            if (this.default_ != null && !this.lhm.containsKey(this.default_)) {
                this.lhm.put(this.default_, this.default_);
            }
            if (!this.lhm.containsKey("")) {
                this.lhm.put("", "");
            }
            this.combo = new JComboBox<Object>(this.lhm.values().toArray());
            this.combo.setEditable(this.editable);
            if (this.usage.allSimilar().booleanValue() && !this.usage.unused().booleanValue()) {
                this.originalValue = this.usage.getFirst();
                this.combo.setSelectedItem(this.lhm.get(this.originalValue));
            } else if (this.default_ != null && !this.usage.hadKeys().booleanValue()) {
                this.combo.setSelectedItem(this.default_);
                this.originalValue = DIFFERENT;
            } else if (this.usage.unused().booleanValue()) {
                this.combo.setSelectedItem("");
                this.originalValue = "";
            } else {
                this.combo.setSelectedItem(DIFFERENT);
                this.originalValue = DIFFERENT;
            }
            if (this.locale_text == null) {
                this.locale_text = I18n.tr(this.text);
            }
            jPanel.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            jPanel.add((Component)this.combo, GBC.eol().fill(2));
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> collection, List<Command> list) {
            Object object = this.combo.getSelectedItem();
            String string = object == null ? null : object.toString();
            String string2 = null;
            if (string == null && this.combo.isEditable()) {
                string = this.combo.getEditor().getItem().toString();
            }
            if (string != null) {
                for (String string3 : this.lhm.keySet()) {
                    String string4 = this.lhm.get(string3);
                    if (string4 == null || !string4.equals(string)) continue;
                    string2 = string3;
                }
                if (string2 == null) {
                    string2 = string;
                }
            } else {
                string2 = "";
            }
            if (string2.equals(this.originalValue) || this.originalValue == null && (string2 == null || string2.length() == 0)) {
                return;
            }
            if (this.delete_if_empty && string2 != null && string2.length() == 0) {
                string2 = null;
            }
            list.add(new ChangePropertyCommand(collection, this.key, string2));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.combo.requestFocusInWindow();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Check
    extends Item {
        public String key;
        public String text;
        public String locale_text;
        public boolean default_ = false;
        public boolean use_last_as_default = false;
        private QuadStateCheckBox check;
        private QuadStateCheckBox.State initialState;
        private boolean def;

        @Override
        public void addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            Usage usage = TaggingPreset.determineBooleanUsage(collection, this.key);
            this.def = this.default_;
            if (this.locale_text == null) {
                this.locale_text = I18n.tr(this.text);
            }
            String string = null;
            Iterator<Object> iterator = usage.values.iterator();
            while (iterator.hasNext()) {
                String object;
                string = object = iterator.next();
            }
            if (usage.values.size() < 2 && (string == null || "yes".equals(string) || "no".equals(string))) {
                if (this.def) {
                    for (OsmPrimitive osmPrimitive : collection) {
                        if (osmPrimitive.keys == null || osmPrimitive.keys.size() <= 0) continue;
                        this.def = false;
                    }
                }
                this.initialState = "yes".equals(string) ? QuadStateCheckBox.State.SELECTED : ("no".equals(string) ? QuadStateCheckBox.State.NOT_SELECTED : (this.def ? QuadStateCheckBox.State.SELECTED : QuadStateCheckBox.State.UNSET));
                this.check = new QuadStateCheckBox(this.locale_text, this.initialState, new QuadStateCheckBox.State[]{QuadStateCheckBox.State.SELECTED, QuadStateCheckBox.State.NOT_SELECTED, QuadStateCheckBox.State.UNSET});
            } else {
                this.def = false;
                this.initialState = QuadStateCheckBox.State.PARTIAL;
                this.check = new QuadStateCheckBox(this.locale_text, QuadStateCheckBox.State.PARTIAL, new QuadStateCheckBox.State[]{QuadStateCheckBox.State.PARTIAL, QuadStateCheckBox.State.SELECTED, QuadStateCheckBox.State.NOT_SELECTED, QuadStateCheckBox.State.UNSET});
            }
            jPanel.add((Component)this.check, GBC.eol().fill(2));
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> collection, List<Command> list) {
            if (this.check.getState() == this.initialState && !this.def) {
                return;
            }
            list.add(new ChangePropertyCommand(collection, this.key, this.check.getState() == QuadStateCheckBox.State.SELECTED ? "yes" : (this.check.getState() == QuadStateCheckBox.State.NOT_SELECTED ? "no" : null)));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.check.requestFocusInWindow();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Text
    extends Item {
        public String key;
        public String text;
        public String locale_text;
        public String default_;
        public String originalValue;
        public boolean use_last_as_default = false;
        public boolean delete_if_empty = false;
        private JComponent value;

        @Override
        public void addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            Usage usage = TaggingPreset.determineTextUsage(collection, this.key);
            if (usage.unused().booleanValue()) {
                this.value = new JTextField();
                if (this.use_last_as_default && lastValue.containsKey(this.key)) {
                    ((JTextField)this.value).setText((String)lastValue.get(this.key));
                } else {
                    ((JTextField)this.value).setText(this.default_);
                }
                this.originalValue = null;
            } else if (usage.allSimilar().booleanValue()) {
                this.value = new JTextField();
                for (String string : usage.values) {
                    ((JTextField)this.value).setText(string);
                }
                this.originalValue = ((JTextField)this.value).getText();
            } else {
                this.value = new JComboBox<Object>(usage.values.toArray());
                ((JComboBox)this.value).setEditable(true);
                ((JComboBox)this.value).getEditor().setItem(DIFFERENT);
                this.originalValue = DIFFERENT;
            }
            if (this.locale_text == null) {
                this.locale_text = I18n.tr(this.text);
            }
            jPanel.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            jPanel.add((Component)this.value, GBC.eol().fill(2));
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> collection, List<Command> list) {
            String string;
            String string2 = string = this.value instanceof JComboBox ? ((JComboBox)this.value).getEditor().getItem().toString() : ((JTextField)this.value).getText();
            if (this.use_last_as_default) {
                lastValue.put(this.key, string);
            }
            if (string.equals(this.originalValue) || this.originalValue == null && string.length() == 0) {
                return;
            }
            if (this.delete_if_empty && string.length() == 0) {
                string = null;
            }
            list.add(new ChangePropertyCommand(collection, this.key, string));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.value.requestFocusInWindow();
        }
    }

    public static class Usage {
        Set<String> values;
        Boolean hadKeys = false;
        Boolean hadEmpty = false;

        public Boolean allSimilar() {
            return this.values.size() == 1 && this.hadEmpty == false;
        }

        public Boolean unused() {
            return this.values.size() == 0;
        }

        public String getFirst() {
            return (String)this.values.toArray()[0];
        }

        public Boolean hadKeys() {
            return this.hadKeys;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Item {
        public boolean focus = false;

        abstract void addToPanel(JPanel var1, Collection<OsmPrimitive> var2);

        abstract void addCommands(Collection<OsmPrimitive> var1, List<Command> var2);

        boolean requestFocusInWindow() {
            return false;
        }
    }
}

