/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.CoordinateConflictResolveCommand;
import org.openstreetmap.josm.command.DeletedStateConflictResolveCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.MergeDecisionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesMergeModel
extends Observable {
    public static final String RESOLVED_COMPLETELY_PROP = PropertiesMergeModel.class.getName() + ".resolvedCompletely";
    private LatLon myCoords;
    private LatLon theirCoords;
    private MergeDecisionType coordMergeDecision = MergeDecisionType.UNDECIDED;
    private boolean myDeletedState;
    private boolean theirDeletedState;
    private MergeDecisionType deletedMergeDecision = MergeDecisionType.UNDECIDED;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean resolvedCompletely = false;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void fireCompletelyResolved() {
        boolean bl = this.resolvedCompletely;
        this.resolvedCompletely = this.isResolvedCompletely();
        this.support.firePropertyChange(RESOLVED_COMPLETELY_PROP, bl, this.resolvedCompletely);
    }

    public boolean isDecidedCoord() {
        return !this.coordMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
    }

    public boolean isDecidedDeletedState() {
        return !this.deletedMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
    }

    public boolean isCoordMergeDecision(MergeDecisionType mergeDecisionType) {
        return this.coordMergeDecision.equals((Object)mergeDecisionType);
    }

    public boolean isDeletedStateDecision(MergeDecisionType mergeDecisionType) {
        return this.deletedMergeDecision.equals((Object)mergeDecisionType);
    }

    public void populate(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        if (osmPrimitive instanceof Node) {
            this.myCoords = ((Node)osmPrimitive).getCoor();
            this.theirCoords = ((Node)osmPrimitive2).getCoor();
        } else {
            this.myCoords = null;
            this.theirCoords = null;
        }
        this.myDeletedState = osmPrimitive.deleted;
        this.theirDeletedState = osmPrimitive2.deleted;
        this.coordMergeDecision = MergeDecisionType.UNDECIDED;
        this.deletedMergeDecision = MergeDecisionType.UNDECIDED;
        this.setChanged();
        this.notifyObservers();
        this.fireCompletelyResolved();
    }

    public LatLon getMyCoords() {
        return this.myCoords;
    }

    public LatLon getTheirCoords() {
        return this.theirCoords;
    }

    public LatLon getMergedCoords() {
        switch (this.coordMergeDecision) {
            case KEEP_MINE: {
                return this.myCoords;
            }
            case KEEP_THEIR: {
                return this.theirCoords;
            }
            case UNDECIDED: {
                return null;
            }
        }
        return null;
    }

    public void decideCoordsConflict(MergeDecisionType mergeDecisionType) {
        this.coordMergeDecision = mergeDecisionType;
        this.setChanged();
        this.notifyObservers();
        this.fireCompletelyResolved();
    }

    public Boolean getMyDeletedState() {
        return this.myDeletedState;
    }

    public Boolean getTheirDeletedState() {
        return this.theirDeletedState;
    }

    public Boolean getMergedDeletedState() {
        switch (this.deletedMergeDecision) {
            case KEEP_MINE: {
                return this.myDeletedState;
            }
            case KEEP_THEIR: {
                return this.theirDeletedState;
            }
            case UNDECIDED: {
                return null;
            }
        }
        return null;
    }

    public void decideDeletedStateConflict(MergeDecisionType mergeDecisionType) {
        this.deletedMergeDecision = mergeDecisionType;
        this.setChanged();
        this.notifyObservers();
        this.fireCompletelyResolved();
    }

    public boolean hasCoordConflict() {
        if (this.myCoords == null && this.theirCoords != null) {
            return true;
        }
        if (this.myCoords != null && this.theirCoords == null) {
            return true;
        }
        if (this.myCoords == null && this.theirCoords == null) {
            return false;
        }
        return !this.myCoords.equalsEpsilon(this.theirCoords);
    }

    public boolean hasDeletedStateConflict() {
        return this.myDeletedState != this.theirDeletedState;
    }

    public boolean isResolvedCompletely() {
        boolean bl = true;
        if (this.hasCoordConflict()) {
            boolean bl2 = bl = bl && !this.coordMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
        }
        if (this.hasDeletedStateConflict()) {
            bl = bl && !this.deletedMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
        }
        return bl;
    }

    public List<Command> buildResolveCommand(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        if (this.hasCoordConflict() && this.isDecidedCoord()) {
            arrayList.add(new CoordinateConflictResolveCommand((Node)osmPrimitive, (Node)osmPrimitive2, this.coordMergeDecision));
        }
        if (this.hasDeletedStateConflict() && this.isDecidedDeletedState()) {
            arrayList.add(new DeletedStateConflictResolveCommand(osmPrimitive, osmPrimitive2, this.coordMergeDecision));
        }
        return arrayList;
    }
}

