/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.tools.I18n;

public class Mercator
implements Projection {
    public EastNorth latlon2eastNorth(LatLon latLon) {
        return new EastNorth(latLon.lon() * Math.PI / 180.0, Math.log(Math.tan(0.7853981633974483 + latLon.lat() * Math.PI / 360.0)));
    }

    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        return new LatLon(Math.atan(Math.sinh(eastNorth.north())) * 180.0 / Math.PI, eastNorth.east() * 180.0 / Math.PI);
    }

    public String toString() {
        return I18n.tr("Mercator");
    }

    public String toCode() {
        return "EPSG:3857";
    }

    public String getCacheDirectoryName() {
        return "mercator";
    }

    public double scaleFactor() {
        return 0.15915494309189535;
    }

    public boolean equals(Object object) {
        return object instanceof Mercator;
    }

    public int hashCode() {
        return Mercator.class.hashCode();
    }
}

