/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Way
extends OsmPrimitive {
    public final List<Node> nodes = new ArrayList<Node>();
    public boolean isMappaintArea = false;
    public Integer mappaintDrawnAreaCode = 0;

    @Override
    protected void clearCached() {
        super.clearCached();
        this.isMappaintArea = false;
        this.mappaintDrawnAreaCode = 0;
    }

    public void visitNodes(Visitor visitor) {
        if (this.incomplete) {
            return;
        }
        for (Node node : this.nodes) {
            visitor.visit(node);
        }
    }

    public ArrayList<Pair<Node, Node>> getNodePairs(boolean bl) {
        ArrayList<Pair<Node, Node>> arrayList = new ArrayList<Pair<Node, Node>>();
        if (this.incomplete) {
            return arrayList;
        }
        Node node = null;
        for (Node node2 : this.nodes) {
            if (node == null) {
                node = node2;
                continue;
            }
            Pair<Node, Node> pair = new Pair<Node, Node>(node, node2);
            if (bl) {
                Pair.sort(pair);
            }
            arrayList.add(pair);
            node = node2;
        }
        return arrayList;
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    public Way(Way way) {
        this.cloneFrom(way);
    }

    public Way() {
    }

    public Way(long l) {
        this.id = l;
        this.incomplete = true;
    }

    @Override
    public void cloneFrom(OsmPrimitive osmPrimitive) {
        super.cloneFrom(osmPrimitive);
        this.nodes.clear();
        this.nodes.addAll(((Way)osmPrimitive).nodes);
    }

    public String toString() {
        if (this.incomplete) {
            return "{Way id=" + this.id + " version=" + this.version + " (incomplete)}";
        }
        return "{Way id=" + this.id + " version=" + this.version + " nodes=" + Arrays.toString(this.nodes.toArray()) + "}";
    }

    @Override
    public boolean realEqual(OsmPrimitive osmPrimitive, boolean bl) {
        return osmPrimitive instanceof Way ? super.realEqual(osmPrimitive, bl) && ((Object)this.nodes).equals(((Way)osmPrimitive).nodes) : false;
    }

    @Override
    public int compareTo(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Relation) {
            return 1;
        }
        return osmPrimitive instanceof Way ? Long.valueOf(this.id).compareTo(osmPrimitive.id) : -1;
    }

    @Override
    public String getName() {
        String string;
        if (this.incomplete) {
            string = I18n.tr("incomplete");
        } else {
            string = this.get("name");
            if (string == null) {
                string = this.get("ref");
            }
            if (string == null) {
                string = this.get("highway") != null ? I18n.tr("highway") : (this.get("railway") != null ? I18n.tr("railway") : (this.get("waterway") != null ? I18n.tr("waterway") : (this.get("landuse") != null ? I18n.tr("landuse") : "")));
            }
            int n = new HashSet<Node>(this.nodes).size();
            String string2 = I18n.trn("{0} node", "{0} nodes", n, n);
            string = string + (string.length() > 0 ? " (" + string2 + ")" : string2);
            if (this.errors != null) {
                string = "*" + string;
            }
        }
        return string;
    }

    public void removeNode(Node node) {
        int n;
        boolean bl;
        if (this.incomplete) {
            return;
        }
        boolean bl2 = bl = this.lastNode() == node && this.firstNode() == node;
        while ((n = this.nodes.indexOf(node)) >= 0) {
            this.nodes.remove(n);
        }
        n = this.nodes.size();
        if (bl && n > 2) {
            this.addNode(this.firstNode());
        } else if (n >= 2 && n <= 3 && this.nodes.get(0) == this.nodes.get(n - 1)) {
            this.nodes.remove(n - 1);
        }
    }

    public void removeNodes(Collection<? extends OsmPrimitive> collection) {
        if (this.incomplete) {
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Node)) continue;
            this.removeNode((Node)osmPrimitive);
        }
    }

    public void addNode(Node node) {
        if (this.incomplete) {
            return;
        }
        this.clearCached();
        this.nodes.add(node);
    }

    public void addNode(int n, Node node) {
        if (this.incomplete) {
            return;
        }
        this.clearCached();
        this.nodes.add(n, node);
    }

    public boolean isClosed() {
        if (this.incomplete) {
            return false;
        }
        return this.nodes.size() >= 3 && this.lastNode() == this.firstNode();
    }

    public Node lastNode() {
        if (this.incomplete || this.nodes.size() == 0) {
            return null;
        }
        return this.nodes.get(this.nodes.size() - 1);
    }

    public Node firstNode() {
        if (this.incomplete || this.nodes.size() == 0) {
            return null;
        }
        return this.nodes.get(0);
    }

    public boolean isFirstLastNode(Node node) {
        if (this.incomplete || this.nodes.size() == 0) {
            return false;
        }
        return node == this.firstNode() || node == this.lastNode();
    }
}

