/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.I18n;

public final class Relation
extends OsmPrimitive {
    public final List<RelationMember> members = new ArrayList<RelationMember>();
    static final String[] defnames = new String[]{"name", "ref", "restriction", "note"};
    static Collection<String> names = null;

    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    public Relation(Relation relation) {
        this.cloneFrom(relation);
    }

    public Relation(long l) {
        this.id = l;
        this.incomplete = true;
    }

    public Relation() {
    }

    public void cloneFrom(OsmPrimitive osmPrimitive) {
        super.cloneFrom(osmPrimitive);
        this.members.clear();
        for (RelationMember relationMember : ((Relation)osmPrimitive).members) {
            this.members.add(new RelationMember(relationMember));
        }
    }

    public String toString() {
        return "{Relation id=" + this.id + " version=" + this.version + "}";
    }

    public boolean realEqual(OsmPrimitive osmPrimitive, boolean bl) {
        return osmPrimitive instanceof Relation ? super.realEqual(osmPrimitive, bl) && ((Object)this.members).equals(((Relation)osmPrimitive).members) : false;
    }

    public int compareTo(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Relation ? Long.valueOf(this.id).compareTo(osmPrimitive.id) : -1;
    }

    public String getName() {
        String string;
        if (this.incomplete) {
            string = I18n.tr("incomplete");
        } else {
            String string2;
            string = this.get("type");
            if (string == null) {
                string = I18n.tr("relation");
            }
            string = string + " (";
            if (names == null) {
                names = Main.pref.getCollection("relation.nameOrder", Arrays.asList(defnames));
            }
            String string3 = null;
            Iterator<String> iterator = names.iterator();
            while (iterator.hasNext() && (string3 = this.get(string2 = iterator.next())) == null) {
            }
            if (string3 != null) {
                string = string + "\"" + string3 + "\", ";
            }
            int n = this.members.size();
            string = string + I18n.trn("{0} member", "{0} members", n, n) + ")";
            if (this.errors != null) {
                string = "*" + string;
            }
        }
        return string;
    }

    public boolean isIncomplete() {
        for (RelationMember relationMember : this.members) {
            if (relationMember.member != null) continue;
            return true;
        }
        return false;
    }

    public RelationMember firstMember() {
        if (this.incomplete) {
            return null;
        }
        return this.members.size() == 0 ? null : this.members.get(0);
    }

    public RelationMember lastMember() {
        if (this.incomplete) {
            return null;
        }
        return this.members.size() == 0 ? null : this.members.get(this.members.size() - 1);
    }
}

