/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.awt.GridBagLayout;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.DontShowAgainInfo;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteCommand
extends Command {
    private final Collection<? extends OsmPrimitive> data;

    public DeleteCommand(Collection<? extends OsmPrimitive> collection) {
        this.data = collection;
    }

    public DeleteCommand(OsmPrimitive osmPrimitive) {
        this.data = Collections.singleton(osmPrimitive);
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        for (OsmPrimitive osmPrimitive : this.data) {
            osmPrimitive.delete(true);
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection2.addAll(this.data);
    }

    @Override
    public MutableTreeNode description() {
        NameVisitor nameVisitor = new NameVisitor();
        if (this.data.size() == 1) {
            this.data.iterator().next().visit(nameVisitor);
            return new DefaultMutableTreeNode(new JLabel(I18n.tr("Delete {1} {0}", nameVisitor.name, I18n.tr(nameVisitor.className)), nameVisitor.icon, 0));
        }
        String string = null;
        String string2 = null;
        for (OsmPrimitive object : this.data) {
            object.visit(nameVisitor);
            if (string == null) {
                string = nameVisitor.className;
                string2 = nameVisitor.classNamePlural;
                continue;
            }
            if (string.equals(nameVisitor.className)) continue;
            string = "object";
            string2 = I18n.trn("object", "objects", 2L);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new JLabel(I18n.tr("Delete {0} {1}", this.data.size(), I18n.trn(string, string2, this.data.size())), ImageProvider.get("data", string), 0));
        for (OsmPrimitive osmPrimitive : this.data) {
            osmPrimitive.visit(nameVisitor);
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(nameVisitor.toLabel()));
        }
        return defaultMutableTreeNode;
    }

    public static Command deleteWithReferences(Collection<? extends OsmPrimitive> collection) {
        CollectBackReferencesVisitor collectBackReferencesVisitor = new CollectBackReferencesVisitor(Main.ds);
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.visit(collectBackReferencesVisitor);
        }
        collectBackReferencesVisitor.data.addAll(collection);
        if (collectBackReferencesVisitor.data.isEmpty()) {
            return null;
        }
        if (!DeleteCommand.checkAndConfirmOutlyingDeletes(collectBackReferencesVisitor.data)) {
            return null;
        }
        return new DeleteCommand(collectBackReferencesVisitor.data);
    }

    private static int testRelation(Relation relation, OsmPrimitive osmPrimitive) {
        NameVisitor nameVisitor = new NameVisitor();
        relation.visit(nameVisitor);
        NameVisitor nameVisitor2 = new NameVisitor();
        osmPrimitive.visit(nameVisitor2);
        String string = new String();
        for (RelationMember relationMember : relation.members) {
            if (relationMember.member != osmPrimitive) continue;
            string = relationMember.role;
            break;
        }
        if (string.length() > 0) {
            return new ExtendedDialog(Main.parent, I18n.tr("Conflicting relation"), I18n.tr("Selection \"{0}\" is used by relation \"{1}\" with role {2}.\nDelete from relation?", nameVisitor2.name, nameVisitor.name, string), new String[]{I18n.tr("Delete from relation"), I18n.tr("Cancel")}, new String[]{"dialogs/delete.png", "cancel.png"}).getValue();
        }
        return new ExtendedDialog(Main.parent, I18n.tr("Conflicting relation"), I18n.tr("Selection \"{0}\" is used by relation \"{1}\".\nDelete from relation?", nameVisitor2.name, nameVisitor.name), new String[]{I18n.tr("Delete from relation"), I18n.tr("Cancel")}, new String[]{"dialogs/delete.png", "cancel.png"}).getValue();
    }

    public static Command delete(Collection<? extends OsmPrimitive> collection) {
        return DeleteCommand.delete(collection, true);
    }

    /*
     * WARNING - void declaration
     */
    public static Command delete(Collection<? extends OsmPrimitive> collection, boolean bl) {
        Collection<OsmPrimitive> collection22;
        LinkedList<Command> linkedList;
        if (collection.isEmpty()) {
            return null;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(collection);
        HashSet<Way> hashSet2 = new HashSet<Way>();
        HashMap<OsmPrimitive, Object> hashMap = new HashMap<OsmPrimitive, Object>();
        if (bl) {
            linkedList = new HashSet();
            for (OsmPrimitive osmPrimitive : hashSet) {
                if (!(osmPrimitive instanceof Way)) continue;
                for (Node node : ((Way)osmPrimitive).nodes) {
                    if (node.isTagged()) continue;
                    collection22 = new CollectBackReferencesVisitor(Main.ds, false);
                    node.visit((Visitor)((Object)collection22));
                    ((CollectBackReferencesVisitor)((Object)collection22)).data.removeAll(hashSet);
                    if (!((CollectBackReferencesVisitor)((Object)collection22)).data.isEmpty()) continue;
                    linkedList.add((Command)((Object)node));
                }
            }
            hashSet.addAll((Collection<OsmPrimitive>)linkedList);
        }
        if (!DeleteCommand.checkAndConfirmOutlyingDeletes(hashSet)) {
            return null;
        }
        for (OsmPrimitive osmPrimitive : hashSet) {
            CollectBackReferencesVisitor collectBackReferencesVisitor = new CollectBackReferencesVisitor(Main.ds, false);
            osmPrimitive.visit(collectBackReferencesVisitor);
            for (OsmPrimitive osmPrimitive2 : collectBackReferencesVisitor.data) {
                if (hashSet.contains(osmPrimitive2)) continue;
                if (osmPrimitive2 instanceof Way) {
                    hashSet2.add((Way)osmPrimitive2);
                    continue;
                }
                if (osmPrimitive2 instanceof Relation) {
                    if (DeleteCommand.testRelation((Relation)osmPrimitive2, osmPrimitive) == 1) {
                        collection22 = (Collection)hashMap.get(osmPrimitive2);
                        if (collection22 == null) {
                            collection22 = new HashSet<OsmPrimitive>();
                        }
                        collection22.add(osmPrimitive);
                        hashMap.put(osmPrimitive2, collection22);
                        continue;
                    }
                    return null;
                }
                return null;
            }
        }
        linkedList = new LinkedList<Command>();
        for (Way way : hashSet2) {
            Way way2 = new Way(way);
            way2.removeNodes(hashSet);
            if (way2.nodes.size() < 2) {
                hashSet.add(way);
                CollectBackReferencesVisitor collectBackReferencesVisitor = new CollectBackReferencesVisitor(Main.ds, false);
                way.visit(collectBackReferencesVisitor);
                for (OsmPrimitive osmPrimitive : collectBackReferencesVisitor.data) {
                    if (hashSet.contains(osmPrimitive)) continue;
                    if (osmPrimitive instanceof Relation) {
                        void var12_43;
                        Boolean bl2 = false;
                        Collection collection3 = (Collection)hashMap.get(osmPrimitive);
                        if (collection3 == null) {
                            HashSet hashSet3 = new HashSet();
                        } else {
                            for (OsmPrimitive osmPrimitive3 : collection3) {
                                if (osmPrimitive3 != way) continue;
                                Boolean bl3 = true;
                                break;
                            }
                        }
                        if (var12_43.booleanValue()) continue;
                        if (DeleteCommand.testRelation((Relation)osmPrimitive, way) == 1) {
                            void var13_50;
                            var13_50.add(way);
                            hashMap.put(osmPrimitive, var13_50);
                            continue;
                        }
                        return null;
                    }
                    return null;
                }
                continue;
            }
            linkedList.add(new ChangeCommand(way, way2));
        }
        for (Relation relation : hashMap.keySet()) {
            Relation relation2 = new Relation(relation);
            block8: for (Collection<OsmPrimitive> collection22 : (Collection)hashMap.get(relation)) {
                for (RelationMember relationMember : relation2.members) {
                    if (relationMember.member != collection22) continue;
                    RelationMember relationMember2 = new RelationMember();
                    relationMember2.role = relationMember.role;
                    relationMember2.member = relationMember.member;
                    relation2.members.remove(relationMember2);
                    continue block8;
                }
            }
            linkedList.add(new ChangeCommand(relation, relation2));
        }
        for (OsmPrimitive osmPrimitive : hashSet) {
            if (!(osmPrimitive instanceof Way)) continue;
            Way way = (Way)osmPrimitive;
            if (way.id == 0L) continue;
            collection22 = new Way(way);
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node node : ((Way)((Object)collection22)).nodes) {
                if (node.id != 0L || !hashSet.contains(node)) continue;
                arrayList.add(node);
            }
            ((Way)((Object)collection22)).nodes.removeAll(arrayList);
            if (arrayList.isEmpty()) continue;
            linkedList.add(new ChangeCommand(way, (OsmPrimitive)((Object)collection22)));
        }
        if (!hashSet.isEmpty()) {
            linkedList.add(new DeleteCommand(hashSet));
        }
        return new SequenceCommand(I18n.tr("Delete"), linkedList);
    }

    public static Command deleteWaySegment(WaySegment waySegment) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList.addAll(waySegment.way.nodes.subList(0, waySegment.lowerIndex + 1));
        arrayList2.addAll(waySegment.way.nodes.subList(waySegment.lowerIndex + 1, waySegment.way.nodes.size()));
        if (arrayList.size() < 2 && arrayList2.size() < 2) {
            return new DeleteCommand(Collections.singleton(waySegment.way));
        }
        Way way = new Way(waySegment.way);
        way.nodes.clear();
        if (arrayList.size() < 2) {
            way.nodes.addAll(arrayList2);
            return new ChangeCommand(waySegment.way, way);
        }
        if (arrayList2.size() < 2) {
            way.nodes.addAll(arrayList);
            return new ChangeCommand(waySegment.way, way);
        }
        LinkedList<Command> linkedList = new LinkedList<Command>();
        way.nodes.addAll(arrayList);
        linkedList.add(new ChangeCommand(waySegment.way, way));
        Way way2 = new Way();
        if (way.keys != null) {
            way2.keys = new HashMap(way.keys);
        }
        way2.nodes.addAll(arrayList2);
        linkedList.add(new AddCommand(way2));
        return new SequenceCommand(I18n.tr("Split way segment"), linkedList);
    }

    private static boolean checkAndConfirmOutlyingDeletes(Collection<OsmPrimitive> collection) {
        Area area = Main.ds.getDataSourceArea();
        if (area != null) {
            for (OsmPrimitive osmPrimitive : collection) {
                Node node;
                if (!(osmPrimitive instanceof Node) || osmPrimitive.id == 0L || area.contains((node = (Node)osmPrimitive).getCoor())) continue;
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.add(new JLabel("<html>" + I18n.tr("You are about to delete nodes outside of the area you have downloaded.<br>This can cause problems because other objects (that you don't see) might use them.<br>Do you really want to delete?") + "</html>"));
                return DontShowAgainInfo.show("delete_outside_nodes", jPanel, false, 0, 0);
            }
        }
        return true;
    }
}

