/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.historycombobox.JHistoryComboBox;
import org.openstreetmap.josm.gui.historycombobox.SuggestingJHistoryComboBox;
import org.openstreetmap.josm.io.OsmServerWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class UploadAction
extends JosmAction {
    public static final String HISTORY_KEY = "upload.comment.history";
    public final LinkedList<UploadHook> uploadHooks = new LinkedList();

    public UploadAction() {
        super(I18n.tr("Upload to OSM..."), "upload", I18n.tr("Upload all changes to the OSM server."), Shortcut.registerShortcut("file:upload", I18n.tr("File: {0}", I18n.tr("Upload to OSM...")), 85, 8), true);
        this.uploadHooks.add(new UploadHook(){

            @Override
            public boolean checkUpload(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
                JComponent jComponent;
                JPanel jPanel = new JPanel(new GridBagLayout());
                OsmPrimitivRenderer osmPrimitivRenderer = new OsmPrimitivRenderer();
                if (!collection.isEmpty()) {
                    jPanel.add((Component)new JLabel(I18n.tr("Objects to add:")), GBC.eol());
                    jComponent = new JList<Object>(collection.toArray());
                    ((JList)jComponent).setCellRenderer(osmPrimitivRenderer);
                    ((JList)jComponent).setVisibleRowCount(((JList)jComponent).getModel().getSize() < 6 ? ((JList)jComponent).getModel().getSize() : 10);
                    jPanel.add((Component)new JScrollPane(jComponent), GBC.eol().fill());
                }
                if (!collection2.isEmpty()) {
                    jPanel.add((Component)new JLabel(I18n.tr("Objects to modify:")), GBC.eol());
                    jComponent = new JList<Object>(collection2.toArray());
                    ((JList)jComponent).setCellRenderer(osmPrimitivRenderer);
                    ((JList)jComponent).setVisibleRowCount(((JList)jComponent).getModel().getSize() < 6 ? ((JList)jComponent).getModel().getSize() : 10);
                    jPanel.add((Component)new JScrollPane(jComponent), GBC.eol().fill());
                }
                if (!collection3.isEmpty()) {
                    jPanel.add((Component)new JLabel(I18n.tr("Objects to delete:")), GBC.eol());
                    jComponent = new JList<Object>(collection3.toArray());
                    ((JList)jComponent).setCellRenderer(osmPrimitivRenderer);
                    ((JList)jComponent).setVisibleRowCount(((JList)jComponent).getModel().getSize() < 6 ? ((JList)jComponent).getModel().getSize() : 10);
                    jPanel.add((Component)new JScrollPane(jComponent), GBC.eol().fill());
                }
                jPanel.add((Component)new JLabel(I18n.tr("Provide a brief comment for the changes you are uploading:")), GBC.eol().insets(0, 5, 10, 3));
                jComponent = new SuggestingJHistoryComboBox();
                LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection(UploadAction.HISTORY_KEY, new LinkedList<String>()));
                ((JHistoryComboBox)jComponent).setHistory(linkedList);
                jPanel.add((Component)jComponent, GBC.eol().fill(2));
                do {
                    int n;
                    if ((n = new ExtendedDialog(Main.parent, I18n.tr("Upload these changes?"), jPanel, new String[]{I18n.tr("Upload Changes"), I18n.tr("Cancel")}, new String[]{"upload.png", "cancel.png"}).getValue()) == 1) continue;
                    return false;
                } while (((JHistoryComboBox)jComponent).getText().trim().length() < 3);
                ((JHistoryComboBox)jComponent).addCurrentItemToHistory();
                Main.pref.putCollection(UploadAction.HISTORY_KEY, ((JHistoryComboBox)jComponent).getHistory());
                return true;
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing to upload. Get some data first."));
            return;
        }
        if (!Main.map.conflictDialog.conflicts.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are unresolved conflicts. You have to resolve these first."));
            Main.map.conflictDialog.action.button.setSelected(true);
            Main.map.conflictDialog.action.actionPerformed(null);
            return;
        }
        final LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        LinkedList<OsmPrimitive> linkedList2 = new LinkedList<OsmPrimitive>();
        LinkedList<OsmPrimitive> linkedList3 = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive object2 : Main.ds.allPrimitives()) {
            if (object2.get("josm/ignore") != null) continue;
            if (object2.id == 0L && !object2.deleted) {
                linkedList.addLast(object2);
                continue;
            }
            if (object2.modified && !object2.deleted) {
                linkedList2.addLast(object2);
                continue;
            }
            if (!object2.deleted || object2.id == 0L) continue;
            linkedList3.addFirst(object2);
        }
        if (linkedList.isEmpty() && linkedList2.isEmpty() && linkedList3.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No changes to upload."));
            return;
        }
        for (UploadHook uploadHook : this.uploadHooks) {
            if (uploadHook.checkUpload(linkedList, linkedList2, linkedList3)) continue;
            return;
        }
        final OsmServerWriter osmServerWriter = new OsmServerWriter();
        final LinkedList<OsmPrimitive> linkedList4 = new LinkedList<OsmPrimitive>();
        linkedList4.addAll(linkedList);
        linkedList4.addAll(linkedList2);
        linkedList4.addAll(linkedList3);
        PleaseWaitRunnable pleaseWaitRunnable = new PleaseWaitRunnable(I18n.tr("Uploading data")){

            protected void realRun() throws SAXException {
                osmServerWriter.uploadOsm(Main.ds.version, linkedList4);
            }

            protected void finish() {
                Main.main.editLayer().cleanData(osmServerWriter.processed, !linkedList.isEmpty());
            }

            protected void cancel() {
            }
        };
        Main.worker.execute(pleaseWaitRunnable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface UploadHook {
        public boolean checkUpload(Collection<OsmPrimitive> var1, Collection<OsmPrimitive> var2, Collection<OsmPrimitive> var3);
    }
}

