/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict;

import org.openstreetmap.josm.gui.conflict.ListRole;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ComparePairType {
    MY_WITH_THEIR(I18n.tr("My with Their"), new ListRole[]{ListRole.MY_ENTRIES, ListRole.THEIR_ENTRIES}),
    MY_WITH_MERGED(I18n.tr("My with Merged"), new ListRole[]{ListRole.MY_ENTRIES, ListRole.MERGED_ENTRIES}),
    THEIR_WITH_MERGED(I18n.tr("Their with Merged"), new ListRole[]{ListRole.THEIR_ENTRIES, ListRole.MERGED_ENTRIES});

    private final String displayName;
    private ListRole[] participatingRoles;

    private ComparePairType(String string2, ListRole[] listRoleArray) {
        this.displayName = string2;
        this.participatingRoles = listRoleArray;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isParticipatingIn(ListRole listRole) {
        for (ListRole listRole2 : this.participatingRoles) {
            if (!listRole2.equals((Object)listRole)) continue;
            return true;
        }
        return false;
    }

    public ListRole[] getParticipatingRoles() {
        return this.participatingRoles;
    }

    public ListRole getOppositeRole(ListRole listRole) {
        if (!this.isParticipatingIn(listRole)) {
            throw new IllegalStateException(I18n.tr("role {0} is not participating in compare pair {1}", listRole.toString(), this.toString()));
        }
        if (this.participatingRoles[0].equals((Object)listRole)) {
            return this.participatingRoles[1];
        }
        return this.participatingRoles[0];
    }
}

