/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.DeleteAction;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.actions.mapmode.ExtrudeAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.actions.mapmode.ZoomAction;
import org.openstreetmap.josm.gui.FileDrop;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MapStatus;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.ScrollViewport;
import org.openstreetmap.josm.gui.dialogs.CommandStackDialog;
import org.openstreetmap.josm.gui.dialogs.ConflictDialog;
import org.openstreetmap.josm.gui.dialogs.HistoryDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.PropertiesDialog;
import org.openstreetmap.josm.gui.dialogs.RelationListDialog;
import org.openstreetmap.josm.gui.dialogs.SelectionListDialog;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.UserListDialog;
import org.openstreetmap.josm.tools.Destroyable;

public class MapFrame
extends JPanel
implements Destroyable {
    public MapMode mapMode;
    public MapView mapView;
    private JToolBar toolBarActions = new JToolBar(1);
    private JToolBar toolBarToggle = new JToolBar(1);
    public MapStatus statusLine;
    public ConflictDialog conflictDialog;
    public RelationListDialog relationListDialog;
    public JPanel toggleDialogs = new JPanel();
    public ArrayList<ToggleDialog> allDialogs = new ArrayList();
    public final ButtonGroup toolGroup = new ButtonGroup();

    public MapFrame() {
        this.setSize(400, 400);
        this.setLayout(new BorderLayout());
        this.mapView = new MapView();
        this.add((Component)this.mapView, "Center");
        new FileDrop(this.mapView);
        Main.main.menu.viewMenu.setVisible(true);
        this.toolBarActions.setFloatable(false);
        this.addMapMode(new IconToggleButton(new SelectAction(this)));
        this.addMapMode(new IconToggleButton(new DrawAction(this)));
        this.addMapMode(new IconToggleButton(new ExtrudeAction(this)));
        this.addMapMode(new IconToggleButton(new ZoomAction(this)));
        this.addMapMode(new IconToggleButton(new DeleteAction(this)));
        this.toolGroup.setSelected(((AbstractButton)this.toolBarActions.getComponent(0)).getModel(), true);
        this.add((Component)this.toggleDialogs, "East");
        this.toggleDialogs.setLayout(new BoxLayout(this.toggleDialogs, 1));
        this.toolBarToggle.setFloatable(false);
        this.addToggleDialog(new LayerListDialog(this));
        this.addToggleDialog(new PropertiesDialog(this));
        this.addToggleDialog(new HistoryDialog());
        this.addToggleDialog(new SelectionListDialog());
        this.addToggleDialog(new UserListDialog());
        this.conflictDialog = new ConflictDialog();
        this.addToggleDialog(this.conflictDialog);
        this.addToggleDialog(new CommandStackDialog(this));
        this.relationListDialog = new RelationListDialog();
        this.addToggleDialog(this.relationListDialog);
        this.statusLine = new MapStatus(this);
    }

    public void selectSelectTool(boolean bl) {
        if (bl && !Main.pref.getBoolean("modeless", false)) {
            return;
        }
        this.selectMapMode((MapMode)this.getDefaultButtonAction());
    }

    public void selectDrawTool(boolean bl) {
        if (bl && !Main.pref.getBoolean("modeless", false)) {
            return;
        }
        Action action = ((AbstractButton)this.toolBarActions.getComponent(1)).getAction();
        this.selectMapMode((MapMode)action);
    }

    public void destroy() {
        int n;
        for (ToggleDialog toggleDialog : this.allDialogs) {
            toggleDialog.close();
        }
        for (n = 0; n < this.toolBarActions.getComponentCount(); ++n) {
            if (!(this.toolBarActions.getComponent(n) instanceof Destroyable)) continue;
            ((Destroyable)((Object)this.toolBarActions)).destroy();
        }
        for (n = 0; n < this.toolBarToggle.getComponentCount(); ++n) {
            if (!(this.toolBarToggle.getComponent(n) instanceof Destroyable)) continue;
            ((Destroyable)((Object)this.toolBarToggle)).destroy();
        }
        Main.main.menu.viewMenu.setVisible(false);
        if (this.statusLine.thread == null) {
            return;
        }
        try {
            this.statusLine.thread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Action getDefaultButtonAction() {
        return ((AbstractButton)this.toolBarActions.getComponent(0)).getAction();
    }

    public void setVisibleDialogs() {
        for (Component component : this.toggleDialogs.getComponents()) {
            if (!(component instanceof ToggleDialog)) continue;
            boolean bl = Main.pref.getBoolean(((ToggleDialog)component).prefName + ".visible");
            ((ToggleDialog)component).action.button.setSelected(bl);
            component.setVisible(bl);
        }
    }

    public IconToggleButton addToggleDialog(ToggleDialog toggleDialog) {
        IconToggleButton iconToggleButton = new IconToggleButton(toggleDialog.action);
        toggleDialog.action.button = iconToggleButton;
        toggleDialog.parent = this.toggleDialogs;
        this.toolBarToggle.add(iconToggleButton);
        this.toggleDialogs.add(toggleDialog);
        this.allDialogs.add(toggleDialog);
        return iconToggleButton;
    }

    public void addMapMode(IconToggleButton iconToggleButton) {
        this.toolBarActions.add(iconToggleButton);
        this.toolGroup.add(iconToggleButton);
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        super.setVisible(bl);
        if (bl2 != bl) {
            this.firePropertyChange("visible", bl2, bl);
        }
    }

    public void selectMapMode(MapMode mapMode) {
        if (mapMode == this.mapMode) {
            return;
        }
        if (this.mapMode != null) {
            this.mapMode.exitMode();
        }
        this.mapMode = mapMode;
        mapMode.enterMode();
    }

    public void fillPanel(Container container) {
        container.add((Component)this, "Center");
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.add(this.toolBarActions);
        jToolBar.addSeparator();
        jToolBar.add(this.toolBarToggle);
        if (Main.pref.getBoolean("sidetoolbar.visible", true)) {
            if (Main.pref.getBoolean("sidetoolbar.scrollable", true)) {
                container.add((Component)new ScrollViewport(jToolBar, 3), "West");
            } else {
                container.add((Component)jToolBar, "West");
            }
        }
        if (this.statusLine != null && Main.pref.getBoolean("statusline.visible", true)) {
            container.add((Component)this.statusLine, "South");
        }
    }
}

