/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.MergeDecisionType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinateConflictResolveCommand
extends Command {
    private final Node my;
    private final Node their;
    private final MergeDecisionType decision;

    protected String getPrimitiveTypeAsString(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            return I18n.tr("node");
        }
        if (osmPrimitive instanceof Way) {
            return I18n.tr("way");
        }
        if (osmPrimitive instanceof Relation) {
            return I18n.tr("relation");
        }
        return "";
    }

    public CoordinateConflictResolveCommand(Node node, Node node2, MergeDecisionType mergeDecisionType) {
        this.my = node;
        this.their = node2;
        this.decision = mergeDecisionType;
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Resolve conflicts in coordinates in {0}", this.my.id), ImageProvider.get("data", "object"), 0));
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (!this.decision.equals((Object)MergeDecisionType.KEEP_MINE)) {
            if (this.decision.equals((Object)MergeDecisionType.KEEP_THEIR)) {
                this.my.setCoor(this.their.getCoor());
            } else {
                throw new IllegalStateException(I18n.tr("cannot resolve undecided conflict"));
            }
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.my);
    }

    @Override
    public void undoCommand() {
        super.undoCommand();
        if (!Main.map.conflictDialog.conflicts.containsKey(this.my)) {
            Main.map.conflictDialog.addConflict(this.my, this.their);
        }
    }
}

