/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class OpenFileAction
extends DiskAccessAction {
    public OpenFileAction() {
        super(I18n.tr("Open..."), "open", I18n.tr("Open a file."), Shortcut.registerShortcut("system:open", I18n.tr("File: {0}", I18n.tr("Open...")), 79, 2));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = OpenFileAction.createAndOpenFileChooser(true, true, null);
        if (jFileChooser == null) {
            return;
        }
        File[] fileArray = jFileChooser.getSelectedFiles();
        for (int i = fileArray.length; i > 0; --i) {
            this.openFile(fileArray[i - 1]);
        }
    }

    public void openFile(File file) {
        try {
            System.out.println("Open file: " + file.getAbsolutePath() + " (" + file.length() + " bytes)");
            for (FileImporter fileImporter : ExtensionFileFilter.importers) {
                if (!fileImporter.acceptFile(file)) continue;
                fileImporter.importData(file);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read \"{0}\"", file.getName()) + "\n" + iOException.getMessage());
        }
    }
}

