/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

public class HistoryInfoAction
extends JosmAction {
    public HistoryInfoAction() {
        super(I18n.tr("History of Element"), "about", I18n.tr("Display history information about OSM ways or nodes."), Shortcut.registerShortcut("core:history", I18n.tr("History of Element"), 72, 1), true);
    }

    protected String getBaseURL() {
        String string = Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api");
        Pattern pattern = Pattern.compile("/api/?$");
        String string2 = pattern.matcher(string).replaceAll("/browse");
        if (string2.equals(string)) {
            System.out.println("WARNING: unexpected format of API base URL. Redirection to history page for OSM primitive will probably fail. API base URL is: " + string);
        }
        return string2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final LinkedList linkedList = new LinkedList();
        final String string = this.getBaseURL();
        new AbstractVisitor(){

            public void visit(Node node) {
                if (node.id <= 0L) {
                    return;
                }
                OpenBrowser.displayUrl(string + "/node/" + node.id + "/history");
                linkedList.add(node);
            }

            public void visit(Way way) {
                if (way.id <= 0L) {
                    return;
                }
                OpenBrowser.displayUrl(string + "/way/" + way.id + "/history");
                linkedList.add(way);
            }

            public void visit(Relation relation) {
                if (relation.id <= 0L) {
                    return;
                }
                OpenBrowser.displayUrl(string + "/relation/" + relation.id + "/history");
                linkedList.add(relation);
            }

            public void visitAll() {
                for (OsmPrimitive osmPrimitive : Main.ds.getSelected()) {
                    osmPrimitive.visit(this);
                }
            }
        }.visitAll();
        if (linkedList.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one node, way or relation. Only already uploaded elements have a history."));
            return;
        }
    }
}

