/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.PluginDownloader;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginSelection {
    private Map<String, Boolean> pluginMap;
    private Map<String, PluginInformation> availablePlugins;

    public void updateDescription(JPanel jPanel) {
        int n = PluginDownloader.downloadDescription();
        if (n > 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.trn("Downloaded plugin information from {0} site", "Downloaded plugin information from {0} sites", n, n));
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No plugin information found."));
        }
        this.drawPanel(jPanel);
    }

    public void update(JPanel jPanel) {
        int n = PluginDownloader.downloadDescription();
        Boolean bl = false;
        this.drawPanel(jPanel);
        HashSet<PluginInformation> hashSet = new HashSet<PluginInformation>();
        StringBuilder stringBuilder = new StringBuilder();
        for (PluginProxy pluginProxy : PluginHandler.pluginList) {
            PluginInformation pluginInformation = this.availablePlugins.get(pluginProxy.info.name);
            if (!(pluginInformation != null && (pluginInformation.version == null || pluginInformation.version.equals("")) ? pluginProxy.info.version != null && pluginProxy.info.version.equals("") : !pluginInformation.version.equals(pluginProxy.info.version))) continue;
            hashSet.add(pluginInformation);
            stringBuilder.append(pluginInformation.name + "\n");
        }
        if (hashSet.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("All installed plugins are up to date."));
            bl = true;
        } else {
            int n2 = new ExtendedDialog(Main.parent, I18n.tr("Update"), I18n.tr("Update the following plugins:\n\n{0}", stringBuilder.toString()), new String[]{I18n.tr("Update Plugins"), I18n.tr("Cancel")}, new String[]{"dialogs/refresh.png", "cancel.png"}).getValue();
            if (n2 == 1) {
                PluginDownloader.update(hashSet);
                bl = true;
            }
        }
        if (bl.booleanValue() && n >= 1) {
            Main.pref.put("pluginmanager.lastupdate", Long.toString(System.currentTimeMillis()));
        }
        this.drawPanel(jPanel);
    }

    public Boolean finish() {
        LinkedList<PluginInformation> linkedList = new LinkedList<PluginInformation>();
        String string = "";
        for (Map.Entry<String, Boolean> object : this.pluginMap.entrySet()) {
            if (!object.getValue().booleanValue() || PluginInformation.findPlugin(object.getKey()) != null) continue;
            linkedList.add(this.availablePlugins.get(object.getKey()));
            string = string + object.getKey() + "\n";
        }
        if (!linkedList.isEmpty()) {
            int n = new ExtendedDialog(Main.parent, I18n.tr("Download missing plugins"), I18n.tr("Download the following plugins?\n\n{0}", string), new String[]{I18n.tr("Download Plugins"), I18n.tr("Cancel")}, new String[]{"download.png", "cancel.png"}).getValue();
            if (n != 1) {
                for (PluginInformation pluginInformation : linkedList) {
                    this.pluginMap.put(pluginInformation.name, false);
                }
            } else {
                for (PluginInformation pluginInformation : linkedList) {
                    if (PluginDownloader.downloadPlugin(pluginInformation)) continue;
                    this.pluginMap.put(pluginInformation.name, false);
                }
            }
        }
        LinkedList linkedList2 = new LinkedList();
        for (Map.Entry<String, Boolean> entry : this.pluginMap.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            linkedList2.add(entry.getKey());
        }
        Collections.sort(linkedList2);
        return Main.pref.putCollection("plugins", linkedList2);
    }

    public void drawPanel(JPanel jPanel) {
        Cloneable cloneable;
        this.availablePlugins = this.getAvailablePlugins();
        Collection<String> collection = Main.pref.getCollection("plugins", null);
        if (this.pluginMap == null) {
            this.pluginMap = new HashMap<String, Boolean>();
        } else {
            cloneable = new HashSet();
            for (String object : this.pluginMap.keySet()) {
                if (this.availablePlugins.get(object) != null) continue;
                cloneable.add(object);
            }
            Iterator<String> iterator = cloneable.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                this.pluginMap.remove(string);
            }
        }
        jPanel.removeAll();
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).gridx = 0;
        ((GridBagConstraints)cloneable).anchor = 18;
        int n = 0;
        for (final PluginInformation pluginInformation : this.availablePlugins.values()) {
            String string;
            PluginInformation pluginInformation2;
            String string2;
            boolean bl;
            boolean bl2 = bl = collection != null && collection.contains(pluginInformation.name);
            if (this.pluginMap.get(pluginInformation.name) == null) {
                this.pluginMap.put(pluginInformation.name, bl);
            }
            if ((string2 = pluginInformation.version) == null || string2.equals("")) {
                string2 = I18n.tr("unknown");
            }
            if ((pluginInformation2 = PluginInformation.findPlugin(pluginInformation.name)) != null) {
                string = pluginInformation2.version != null && !pluginInformation2.version.equals("") ? pluginInformation2.version : I18n.tr("unknown");
                string = " (" + string + ")";
            } else {
                string = "";
            }
            final JCheckBox jCheckBox = new JCheckBox(I18n.tr("{0}: Version {1}{2}", pluginInformation.name, string2, string), (boolean)this.pluginMap.get(pluginInformation.name));
            ((GridBagConstraints)cloneable).gridy = n++;
            ((GridBagConstraints)cloneable).insets = new Insets(5, 5, 0, 5);
            ((GridBagConstraints)cloneable).weighty = 0.1;
            ((GridBagConstraints)cloneable).fill = 0;
            jPanel.add((Component)jCheckBox, cloneable);
            jCheckBox.setToolTipText(pluginInformation.downloadlink != null ? "" + pluginInformation.downloadlink : I18n.tr("Plugin bundled with JOSM"));
            JEditorPane jEditorPane = new JEditorPane();
            jEditorPane.setContentType("text/html");
            jEditorPane.setEditable(false);
            jEditorPane.setText("<html><i>" + pluginInformation.getLinkDescription() + "</i></html>");
            jEditorPane.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            jEditorPane.setBackground(UIManager.getColor("Panel.background"));
            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        OpenBrowser.displayUrl(hyperlinkEvent.getURL().toString());
                    }
                }
            });
            ((GridBagConstraints)cloneable).gridy = n++;
            ((GridBagConstraints)cloneable).insets = new Insets(3, 5, 5, 5);
            ((GridBagConstraints)cloneable).weighty = 0.9;
            ((GridBagConstraints)cloneable).weightx = 1.0;
            ((GridBagConstraints)cloneable).anchor = 17;
            ((GridBagConstraints)cloneable).fill = 2;
            jPanel.add((Component)jEditorPane, cloneable);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jCheckBox.isSelected()) {
                        PluginInformation pluginInformation2 = PluginInformation.findPlugin(pluginInformation.name);
                        if (PluginSelection.getLoaded(pluginInformation.name) == null && pluginInformation2 != null) {
                            try {
                                int n = new ExtendedDialog(Main.parent, I18n.tr("Plugin already exists"), I18n.tr("Plugin archive already available. Do you want to download the current version by deleting existing archive?\n\n{0}", pluginInformation2.file.getCanonicalPath()), new String[]{I18n.tr("Delete and Download"), I18n.tr("Cancel")}, new String[]{"download.png", "cancel.png"}).getValue();
                                if (n == 1 && !pluginInformation2.file.delete()) {
                                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error deleting plugin file: {0}", pluginInformation2.file.getCanonicalPath()));
                                }
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error deleting plugin file: {0}", iOException.getMessage()));
                            }
                        }
                    }
                    PluginSelection.this.pluginMap.put(pluginInformation.name, jCheckBox.isSelected());
                }
            });
        }
        jPanel.updateUI();
    }

    private static PluginInformation getLoaded(String string) {
        for (PluginProxy pluginProxy : PluginHandler.pluginList) {
            if (!pluginProxy.info.name.equals(string)) continue;
            return pluginProxy.info;
        }
        return null;
    }

    private Map<String, PluginInformation> getAvailablePlugins() {
        TreeMap<String, PluginInformation> treeMap = new TreeMap<String, PluginInformation>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareToIgnoreCase(string2);
            }
        });
        for (String object : PluginInformation.getPluginLocations()) {
            Object[] objectArray = new File(object).listFiles();
            if (objectArray == null) continue;
            Arrays.sort(objectArray);
            for (Object object2 : objectArray) {
                if (!((File)object2).isFile()) continue;
                String string = ((File)object2).getName();
                if (string.endsWith(".jar")) {
                    try {
                        PluginInformation n = new PluginInformation((File)object2, string.substring(0, string.length() - 4), null);
                        if (treeMap.containsKey(n.name)) continue;
                        treeMap.put(n.name, n);
                    }
                    catch (PluginException pluginException) {}
                    continue;
                }
                if (!string.matches("^[0-9]+-site.*\\.txt$")) continue;
                int n = 0;
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)object2), "utf-8"));
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    Object object3 = bufferedReader.readLine();
                    while (object3 != null) {
                        if (((String)object3).startsWith("\t")) {
                            if (((String)(object3 = ((String)object3).substring(1))).length() > 70) {
                                string4 = string4 + ((String)object3).substring(0, 70) + "\n";
                                object3 = " " + ((String)object3).substring(70);
                            }
                            string4 = string4 + (String)object3 + "\n";
                        } else {
                            Object object4;
                            if (string2 != null) {
                                try {
                                    object4 = new PluginInformation(null, string2.substring(0, string2.length() - 4), new ByteArrayInputStream(string4.getBytes()));
                                    object4.downloadlink = string3;
                                    if (!treeMap.containsKey(object4.name)) {
                                        treeMap.put(object4.name, (PluginInformation)object4);
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    ++n;
                                }
                            }
                            object4 = ((String)object3).split(";");
                            string2 = object4[0];
                            string3 = object4[1];
                            string4 = null;
                        }
                        object3 = bufferedReader.readLine();
                    }
                    if (string2 != null) {
                        object3 = new PluginInformation(null, string2.substring(0, string2.length() - 4), new ByteArrayInputStream(string4.getBytes()));
                        ((PluginInformation)object3).downloadlink = string3;
                        if (!treeMap.containsKey(((PluginInformation)object3).name)) {
                            treeMap.put(((PluginInformation)object3).name, (PluginInformation)object3);
                        }
                    }
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    ++n;
                }
                if (n <= 0) continue;
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error reading plugin information file: {0}", ((File)object2).getName()));
            }
        }
        for (PluginProxy pluginProxy : PluginHandler.pluginList) {
            if (treeMap.containsKey(pluginProxy.info.name)) continue;
            treeMap.put(pluginProxy.info.name, pluginProxy.info);
        }
        return treeMap;
    }
}

