/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInformation {
    public final File file;
    public final String name;
    public final String mainversion;
    public final String className;
    public final String requires;
    public final String link;
    public final String description;
    public final boolean early;
    public final String author;
    public final int stage;
    public final String version;
    public String downloadlink = null;
    public final List<URL> libraries = new LinkedList<URL>();
    public final Map<String, String> attr = new TreeMap<String, String>();
    static PluginInformation currentPluginInitialization = null;

    public PluginInformation(File file) {
        this(file, file.getName().substring(0, file.getName().length() - 4), null);
    }

    public PluginInformation(File file, String string, InputStream inputStream) {
        this.name = string;
        this.file = file;
        try {
            Manifest manifest;
            JarInputStream jarInputStream = null;
            if (file != null) {
                jarInputStream = new JarInputStream(new FileInputStream(file));
                manifest = jarInputStream.getManifest();
                if (manifest == null) {
                    throw new IOException(file + " contains no manifest.");
                }
            } else {
                manifest = new Manifest();
                manifest.read(inputStream);
            }
            if (manifest != null) {
                String string2 = Main.getLanguageCode() + "_";
                Attributes attributes = manifest.getMainAttributes();
                this.className = attributes.getValue("Plugin-Class");
                String string3 = attributes.getValue(string2 + "Plugin-Link");
                if (string3 == null) {
                    string3 = attributes.getValue("Plugin-Link");
                }
                this.link = string3;
                this.requires = attributes.getValue("Plugin-Requires");
                string3 = attributes.getValue(string2 + "Plugin-Description");
                if (string3 == null && (string3 = attributes.getValue("Plugin-Description")) != null) {
                    string3 = I18n.tr(string3);
                }
                this.description = string3;
                this.early = Boolean.parseBoolean(attributes.getValue("Plugin-Early"));
                String string4 = attributes.getValue("Plugin-Stage");
                this.stage = string4 == null ? 50 : Integer.parseInt(string4);
                this.version = attributes.getValue("Plugin-Version");
                this.mainversion = attributes.getValue("Plugin-Mainversion");
                this.author = attributes.getValue("Author");
                String string5 = attributes.getValue(Attributes.Name.CLASS_PATH);
                if (string5 != null) {
                    for (String string6 : string5.split(" ")) {
                        File file2 = new File(string6).isAbsolute() ? new File(string6) : new File(file.getParent(), string6);
                        this.libraries.add(PluginInformation.fileToURL(file2));
                    }
                }
                for (Object e : attributes.keySet()) {
                    this.attr.put(e.toString(), attributes.getValue(e.toString()));
                }
            } else {
                this.className = null;
                this.mainversion = null;
                this.description = null;
                this.early = false;
                this.stage = 50;
                this.requires = null;
                this.link = null;
                this.version = null;
                this.author = null;
            }
            if (file != null) {
                this.libraries.add(0, PluginInformation.fileToURL(file));
            }
            if (jarInputStream != null) {
                jarInputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new PluginException(null, string, iOException);
        }
    }

    public String getLinkDescription() {
        String string;
        String string2 = string = this.description == null ? I18n.tr("no description available") : this.description;
        if (this.link != null) {
            string = string + " <A HREF=\"" + this.link + "\">" + I18n.tr("More details") + "</A>";
        }
        return string;
    }

    public PluginProxy load(Class<?> clazz) {
        try {
            currentPluginInitialization = this;
            return new PluginProxy(clazz.newInstance(), this);
        }
        catch (Exception exception) {
            throw new PluginException(null, this.name, exception);
        }
    }

    public Class<?> loadClass(ClassLoader classLoader) {
        if (this.className == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(this.className, true, classLoader);
            return clazz;
        }
        catch (Exception exception) {
            throw new PluginException(null, this.name, exception);
        }
    }

    public static URL fileToURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static PluginInformation findPlugin(String string) throws PluginException {
        String string2 = string;
        string2 = string2.replaceAll("[-. ]", "");
        InputStream inputStream = PluginInformation.class.getResourceAsStream("/org/openstreetmap/josm/plugins/" + string2 + "/MANIFEST.MF");
        if (inputStream != null) {
            return new PluginInformation(null, string, inputStream);
        }
        Collection<String> collection = PluginInformation.getPluginLocations();
        for (String string3 : collection) {
            File file = new File(string3, string + ".jar");
            if (!file.exists()) continue;
            PluginInformation pluginInformation = new PluginInformation(file);
            return pluginInformation;
        }
        return null;
    }

    public static Collection<String> getPluginLocations() {
        Collection<String> collection = Main.pref.getAllPossiblePreferenceDirs();
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (String string : collection) {
            arrayList.add(string + "plugins");
        }
        return arrayList;
    }
}

