/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDownloader {
    private static final String[] pluginSites = new String[]{"http://josm.openstreetmap.de/plugin"};

    public static Collection<String> getSites() {
        return Main.pref.getCollection("pluginmanager.sites", Arrays.asList(pluginSites));
    }

    public static void setSites(Collection<String> collection) {
        Main.pref.putCollection("pluginmanager.sites", collection);
    }

    public static int downloadDescription() {
        int n = 0;
        for (String string : PluginDownloader.getSites()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new URL(string).openStream(), "utf-8"));
                StringBuilder stringBuilder = new StringBuilder();
                Object object = bufferedReader.readLine();
                while (object != null) {
                    stringBuilder.append((String)object + "\n");
                    object = bufferedReader.readLine();
                }
                bufferedReader.close();
                new File(Main.pref.getPreferencesDir() + "plugins").mkdir();
                object = new FileWriter(new File(Main.pref.getPluginsDirFile(), n + "-site-" + string.replaceAll("[/:\\\\ <>|]", "_") + ".txt"));
                ((OutputStreamWriter)object).append(stringBuilder);
                ((OutputStreamWriter)object).close();
                ++n;
            }
            catch (IOException iOException) {}
        }
        return n;
    }

    private static String escape(String string) {
        return string.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static boolean downloadPlugin(PluginInformation pluginInformation) {
        File file = new File(Main.pref.getPluginsDirFile(), pluginInformation.name + ".jar");
        if (!PluginDownloader.download(pluginInformation.downloadlink, file)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not download plugin: {0} from {1}", pluginInformation.name, pluginInformation.downloadlink));
        } else {
            try {
                PluginInformation.findPlugin(pluginInformation.name);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The plugin {0} seems to be broken or could not be downloaded automatically.", pluginInformation.name));
            }
        }
        if (file.exists()) {
            file.delete();
        }
        return false;
    }

    private static boolean download(String string, File file) {
        try {
            InputStream inputStream = new URL(string).openStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[8192];
            int n = inputStream.read(byArray);
            while (n != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            ((OutputStream)fileOutputStream).close();
            inputStream.close();
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public static void update(Collection<PluginInformation> collection) {
        Main.worker.execute(new UpdateTask(collection));
    }

    public static boolean moveUpdatedPlugins() {
        File file = Main.pref.getPluginsDirFile();
        boolean bl = true;
        if (file.exists() && file.isDirectory() && file.canWrite()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".new");
                }
            })) {
                String string = file2.getPath();
                File file3 = new File(string.substring(0, string.length() - 4));
                bl = (file3.delete() || !file3.exists()) && file2.renameTo(file3) && bl;
            }
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UpdateTask
    extends PleaseWaitRunnable {
        private final Collection<PluginInformation> toUpdate;
        private String errors = "";
        private int count = 0;

        private UpdateTask(Collection<PluginInformation> collection) {
            super(I18n.tr("Update Plugins"));
            this.toUpdate = collection;
        }

        @Override
        protected void cancel() {
            this.finish();
        }

        @Override
        protected void finish() {
            if (this.errors.length() > 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were problems with the following plugins:\n\n {0}", this.errors));
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn("{0} Plugin successfully updated. Please restart JOSM.", "{0} Plugins successfully updated. Please restart JOSM.", this.count, this.count));
            }
        }

        @Override
        protected void realRun() throws SAXException, IOException {
            File file = Main.pref.getPluginsDirFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            for (PluginInformation pluginInformation : this.toUpdate) {
                File file2 = new File(file, pluginInformation.name + ".jar.new");
                if (PluginDownloader.download(pluginInformation.downloadlink, file2)) {
                    ++this.count;
                    continue;
                }
                this.errors = this.errors + pluginInformation.name + "\n";
            }
            PluginDownloader.moveUpdatedPlugins();
        }
    }
}

