/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.historycombobox;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.historycombobox.EventConsumingPlainDocument;
import org.openstreetmap.josm.gui.historycombobox.JHistoryComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestingJHistoryComboBox
extends JHistoryComboBox
implements KeyListener {
    private EventConsumingPlainDocument doc = new EventConsumingPlainDocument();

    public SuggestingJHistoryComboBox(List<String> list) {
        super(list);
        this.getEditor().getEditorComponent().addKeyListener(this);
        ((JTextComponent)this.getEditor().getEditorComponent()).setDocument(this.doc);
        JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
        final AbstractDocument abstractDocument = (AbstractDocument)jTextField.getDocument();
        abstractDocument.setDocumentFilter(new DocumentFilter(){

            public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                super.insertString(filterBypass, n, string, attributeSet);
                if (abstractDocument.getLength() > 0) {
                    SuggestingJHistoryComboBox.this.suggest();
                }
            }

            public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                super.replace(filterBypass, n, n2, string, attributeSet);
                if (abstractDocument.getLength() > 0) {
                    SuggestingJHistoryComboBox.this.suggest();
                }
            }
        });
    }

    public SuggestingJHistoryComboBox() {
        this(new ArrayList<String>());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JTextField) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            if ("SUGGEST".equals(actionEvent.getActionCommand())) {
                jTextField.setSelectionStart(jTextField.getText().length());
                jTextField.setSelectionEnd(jTextField.getText().length());
                jTextField.setActionCommand("");
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    private void suggest() {
        JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
        String string = jTextField.getText();
        for (String string2 : this.model) {
            if (!string2.startsWith(string)) continue;
            jTextField.setActionCommand("SUGGEST");
            this.doc.setConsumeEvents(true);
            if (!string.equals(string2)) {
                jTextField.setText(string2);
            }
            jTextField.setSelectionStart(string.length());
            jTextField.setSelectionEnd(jTextField.getText().length());
            this.doc.setConsumeEvents(false);
            break;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32 && keyEvent.isControlDown()) {
            this.suggest();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

