/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class UndoRedoHandler
implements Layer.LayerChangeListener {
    public final LinkedList<Command> commands = new LinkedList();
    private final Stack<Command> redoCommands = new Stack();
    public final LinkedList<OsmDataLayer.CommandQueueListener> listenerCommands = new LinkedList();

    public UndoRedoHandler() {
        Layer.listeners.add(this);
    }

    public void add(Command command) {
        command.executeCommand();
        this.commands.add(command);
        this.redoCommands.clear();
        if (Main.map != null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer) {
            OsmDataLayer osmDataLayer = (OsmDataLayer)Main.map.mapView.getActiveLayer();
            osmDataLayer.setModified(true);
            osmDataLayer.fireDataChange();
        }
        this.fireCommandsChanged();
    }

    public void undo() {
        if (this.commands.isEmpty()) {
            return;
        }
        Command command = this.commands.removeLast();
        command.undoCommand();
        this.redoCommands.push(command);
        if (Main.map != null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer) {
            OsmDataLayer osmDataLayer = (OsmDataLayer)Main.map.mapView.getActiveLayer();
            osmDataLayer.setModified(osmDataLayer.uploadedModified || !this.commands.isEmpty());
            osmDataLayer.fireDataChange();
        }
        this.fireCommandsChanged();
        Main.ds.setSelected(new OsmPrimitive[0]);
    }

    public void redo() {
        if (this.redoCommands.isEmpty()) {
            return;
        }
        Command command = this.redoCommands.pop();
        command.executeCommand();
        this.commands.add(command);
        if (Main.map != null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer) {
            OsmDataLayer osmDataLayer = (OsmDataLayer)Main.map.mapView.getActiveLayer();
            osmDataLayer.setModified(true);
            osmDataLayer.fireDataChange();
        }
        this.fireCommandsChanged();
    }

    public void fireCommandsChanged() {
        for (OsmDataLayer.CommandQueueListener commandQueueListener : this.listenerCommands) {
            commandQueueListener.commandChanged(this.commands.size(), this.redoCommands.size());
        }
    }

    public void clean() {
        this.redoCommands.clear();
        this.commands.clear();
        this.fireCommandsChanged();
    }

    public void layerRemoved(Layer layer) {
        boolean bl = false;
        Iterator iterator = this.commands.iterator();
        while (iterator.hasNext()) {
            if (!((Command)iterator.next()).invalidBecauselayerRemoved(layer)) continue;
            iterator.remove();
            bl = true;
        }
        iterator = this.redoCommands.iterator();
        while (iterator.hasNext()) {
            if (!((Command)iterator.next()).invalidBecauselayerRemoved(layer)) continue;
            iterator.remove();
            bl = true;
        }
        if (bl) {
            this.fireCommandsChanged();
        }
    }

    public void layerAdded(Layer layer) {
    }

    public void activeLayerChange(Layer layer, Layer layer2) {
    }
}

